% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numericsManipulations.R
\name{findAndTransformNumerics}
\alias{findAndTransformNumerics}
\title{Identify numeric columns in a dataSet set}
\usage{
findAndTransformNumerics(dataSet, cols = "auto", n_test = 30, verbose = TRUE)
}
\arguments{
\item{dataSet}{Matrix, data.frame or data.table}

\item{cols}{List of column(s) name(s) of dataSet to look into. To check all all columns, set it 
to "auto". (characters, default to "auto")}

\item{n_test}{Number of non-null rows on which to test (numeric, default to 30)}

\item{verbose}{Should the algorithm talk? (logical, default to TRUE)}
}
\value{
The dataSet set (as a data.table) with identified numeric transformed.
}
\description{
Function to find and transform characters that are in fact numeric.
}
\details{
This function is looking for perfect transformation. 
If there are some mistakes in dataSet, consider setting them to NA before. \cr
If there are some columns that have no chance to be a match think of removing them from \code{cols} 
to save some computation time.
}
\section{Warning}{

All these changes will happen \strong{by reference}.
}

\examples{
# Let's build a dataSet set
dataSet <- data.frame(ID = 1:5,
                  col1 = c("1.2", "1.3", "1.2", "1", "6"), 
                  col2 = c("1,2", "1,3", "1,2", "1", "6")
                  )

# using the findAndTransformNumerics
findAndTransformNumerics(dataSet, n_test = 5)
}
