% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.dist.pop.r
\name{gl.dist.pop}
\alias{gl.dist.pop}
\title{Calculate a distance matrix for populations defined in an \{adegenet\} genlight object}
\usage{
gl.dist.pop(x, method = "euclidean", binary = FALSE, diag = TRUE,
  upper = FALSE, p = NULL, v = 2)
}
\arguments{
\item{x}{-- name of the genlight containing the SNP genotypes [required]}

\item{method}{-- Specify distance measure [method=euclidean]}

\item{binary}{-- Perform presence/absence standardization before analysis using decostand [binary=FALSE]}

\item{diag}{-- Compute and display diagonal [TRUE]}

\item{upper}{-- Return also upper triangle [FALSE]}

\item{p}{-- The power of the Minkowski distance (typically a value ranging from 0.25 to infinity) [0.5]}

\item{v}{-- verbosity: 0, silent or fatal errors; 1, begin and end; 2, progress log ; 3, progress and results summary; 5, full report [default 2]}
}
\value{
A matrix of distances between populations (class dist)
}
\description{
This script calculates various distances between populations based on allele frequencies. The distances are
calculated by scripts in the {stats} or {vegan} libraries, with the exception of the pcfixed (percent fixed
differences) and pa (total private alleles) distances.
}
\details{
The distance measure can be one of "manhattan", "euclidean", "pcfixed", "pa", canberra", "bray", 
"kulczynski", "jaccard", "gower", "morisita", "horn", "mountford", "raup" , 
"binomial", "chao", "cao", "mahalanobis", "maximum", "binary" or "minkowski". Refer to the documentation for
dist stats or vegdist vegan for definitions.

Distance pcfixed calculates the pair-wise count of fixed allelic differences between populations. Distance pa
tallies the total number of private alleles possessed by one or the other population.
}
\examples{
gl.dist.pop(testset.gl, method="euclidean", diag=TRUE)
}
\author{
Arthur Georges (bugs? Post to \url{https://groups.google.com/d/forum/dartr})
}
