% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{GET}
\alias{GET}
\title{GET-requests}
\usage{
GET(url, endpoint = NULL, query = NULL, path = NULL)
}
\arguments{
\item{url}{\link{character} of length 1. The baseurl}

\item{endpoint}{\link{character} of length 1. The API endpoint}

\item{query}{A named \link{list} of queries.}

\item{path}{A \link{list} of paths.}
}
\value{
A \link{list} crated by \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}}
}
\description{
GET-requests
}
\examples{
\dontrun{
  # script start;

  exchange <- "bybit"
  futures  <- FALSE

  # 1) define baseurl
  base_url <- cryptoQuotes:::baseUrl(
    source  = exchange,
    futures = futures
  )

  # 2) define endpoint
  end_point <- cryptoQuotes:::endPoint(
    source  = "bybit",
    futures = futures,
    type    = "ohlc"
  )

  # 2) define actual
  # parameters based on
  # API docs
  queries <- list(
    symbol   = "BTCUSDT",
    category = "spot",
    limit    = 100,
    interval = "D"
  )

  # 3) perform GET request
  cryptoQuotes:::GET(
    url      = base_url,
    endpoint = end_point,
    query    = queries
  )

  # script end;
}
}
\seealso{
Other development tools: 
\code{\link{chart_layout}()},
\code{\link{convert_date}()},
\code{\link{default_dates}()},
\code{\link{fetch}()},
\code{\link{flatten}()},
\code{\link{is.date}()}
}
\concept{development tools}
\keyword{internal}
