% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fs_write.R
\name{write_file}
\alias{write_file}
\alias{write_ext}
\alias{write_ext.txt}
\alias{write_ext.csv}
\alias{write_ext.parquet}
\alias{write_ext.rds}
\alias{write_ext.xpt}
\alias{write_ext.yml}
\alias{write_ext.json}
\alias{write_ext.xlsx}
\title{Write files based on the extension}
\usage{
write_file(x, file, overwrite = FALSE, ...)

write_ext(file, x, ...)

\method{write_ext}{txt}(file, x, ...)

\method{write_ext}{csv}(file, x, delim = ",", ...)

\method{write_ext}{parquet}(file, x, ...)

\method{write_ext}{rds}(file, x, ...)

\method{write_ext}{xpt}(file, x, ...)

\method{write_ext}{yml}(file, x, ...)

\method{write_ext}{json}(file, x, ...)

\method{write_ext}{xlsx}(file, x, ...)
}
\arguments{
\item{x}{Object to write}

\item{file}{\code{\link[=character]{character()}} Path to write the file.}

\item{overwrite}{\link{logical} Overwrite existing content if it exists.}

\item{...}{Other parameters passed on the functions behind the methods for each file extension.}

\item{delim}{\code{\link[=character]{character()}} Delimiter to use. Default is \code{","}.}
}
\value{
\code{write_file()}: \code{\link[=invisible]{invisible()}} file.

\code{write_ext()}: The return of the functions behind the individual methods.
}
\description{
\code{write_file()} is the backbone of all \code{\link[=write_cnt]{write_cnt()}} methods, where files are written
to a connector. The function is a wrapper around \code{write_ext()} where the appropriate
function to write the file is chosen depending on the file extension.

\code{write_ext()} has methods defined for the following file extensions:

\itemize{
\item \code{txt}: \code{\link[readr:read_lines]{readr::write_lines()}}
}

\itemize{
\item \code{csv}: \code{\link[readr:write_delim]{readr::write_csv()}}
}

\itemize{
\item \code{parquet}: \code{\link[arrow:write_parquet]{arrow::write_parquet()}}
}

\itemize{
\item \code{rds}: \code{\link[readr:read_rds]{readr::write_rds()}}
}

\itemize{
\item \code{sas7bdat}: \code{\link[haven:write_sas]{haven::write_sas()}}
}

\itemize{
\item \code{yml}/\code{yaml}: \code{\link[yaml:write_yaml]{yaml::write_yaml()}}
}

\itemize{
\item \code{json}: \code{\link[jsonlite:read_json]{jsonlite::write_json()}}
}

\itemize{
\item \code{excel}: \code{\link[writexl:write_xlsx]{writexl::write_xlsx()}}
}
}
\details{
Note that \code{write_file()} will not overwrite existing files unless \code{overwrite = TRUE},
while all methods for \code{write_ext()} will overwrite existing files by default.
}
\examples{
# Write CSV file
temp_csv <- tempfile("iris", fileext = ".csv")
write_file(iris, temp_csv)

}
