% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_config.R
\name{remove_datasource}
\alias{remove_datasource}
\title{Remove a datasource from a YAML configuration file}
\usage{
remove_datasource(config_path, name)
}
\arguments{
\item{config_path}{The file path to the YAML configuration file}

\item{name}{The name of the datasource to be removed}
}
\value{
(invisible) \code{config_path} where the configuration have been updated
}
\description{
This function removes a datasource from a YAML configuration file based on the
provided name, ensuring that it doesn't interfere with other existing datasources.
}
\examples{
config <- tempfile(fileext = ".yml")

file.copy(
  from = system.file("config", "_connector.yml", package = "connector"),
  to = config
)

config |>
  add_datasource(
    name = "new_datasource",
    backend = list(type = "connector_fs", path = "new_path")
  ) |>
  remove_datasource("new_datasource")
}
