% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso-year-week-day.R
\name{iso-year-week-day-narrow}
\alias{iso-year-week-day-narrow}
\alias{calendar_narrow.clock_iso_year_week_day}
\title{Narrow: iso-year-week-day}
\usage{
\method{calendar_narrow}{clock_iso_year_week_day}(x, precision)
}
\arguments{
\item{x}{\verb{[clock_iso_year_week_day]}

A iso-year-week-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"week"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} narrowed to the supplied \code{precision}.
}
\description{
This is a iso-year-week-day method for the \code{\link[=calendar_narrow]{calendar_narrow()}} generic. It
narrows a iso-year-week-day vector to the specified \code{precision}.
}
\examples{
# Day precision
x <- iso_year_week_day(2019, 1, 5)
x

# Narrowed to week precision
calendar_narrow(x, "week")
}
