% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/loadDataADaMSDTM.R
\name{getLabelVar}
\alias{getLabelVar}
\title{Get label for a variable of the dataset}
\usage{
getLabelVar(var, data = NULL, labelVars = NULL, label = NULL)
}
\arguments{
\item{var}{Character vector with variables of interest.}

\item{data}{Data.frame with data.}

\item{labelVars}{Named character vector with variable labels (names are the variable code),
usually extracted from \code{data}.}

\item{label}{(Named) Character vector with user-specified label for \code{var}.
Label is extracted based on names if variable is available.
If \code{var} is of length 1, \code{label} can also be specified
as an unnamed character.}
}
\value{
Named character vector with label, \code{var} is no label is available
}
\description{
The label is extracted either (in this order):
\enumerate{
\item if \code{label} is specified: from this label based on names,
or directly from this label if \code{label} and \code{var} are of length 1 
(if available)
\item if \code{labelVars} is specified: from the specified vector of labels,
based on names (if available)
\item if \code{data} is specified: from the 'label' attribute 
of the corresponding column in \code{data} (if available)
} 
If the label is not available, the input variable is returned.
}
\examples{

data(dataADaMCDISCP01)
labelVars <- attr(dataADaMCDISCP01, "labelVars")

# (upon reading the data with haven: attributes should directly available in each column)
getLabelVar(data = dataADaMCDISCP01, var = "AEREL")
		
# but if the data as data.frame is subsetted, label is lost 	
# so better to use 'labelVars':
getLabelVar(var = "AEREL", labelVars = labelVars)
}
\author{
Laure Cougnaud
}
