% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{cg_session_set_graph}
\alias{cg_session_set_graph}
\title{Change Active Graph}
\usage{
cg_session_set_graph(graph)
}
\arguments{
\item{graph}{cg_graph object, the graph that is activated.}
}
\value{
none.
}
\description{
Set a graph to be the active graph.
}
\note{
Any nodes that are created are automatically added to the active graph. This also applies to operations that are created by overloaded S3 functions that do not follow the cg_<name> naming convention (such as primitive inflix functions '+' and '-').

Only one graph can be active at a time. The active graph can be changed by calling this function on another cg_graph object.
}
\examples{
# Initialize a computational graph
graph1 <- cg_graph()

# Initialize another computational graph. It becomes the active graph.
graph2 <- cg_graph()

# Set graph1 to be the active graph
cg_session_set_graph(graph1)

}
\author{
Ron Triepels
}
