% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getcescodes.R
\name{get_cescodes}
\alias{get_cescodes}
\title{Print a dataset of the CES survey codes and their associated calls.}
\usage{
get_cescodes(indx = 22)
}
\arguments{
\item{indx}{A numeric value that determines the number of survey codes returned.
Default is set to 22, or the total set of survey codes.}
}
\value{
A printout of a designated number of Canadian Election Study survey codes and
associated character codes used for the \code{get_ces()} function.
}
\description{
\code{get_cescodes()} prints out a data frame of the CES survey codes and the associated calls.
Provides a quick way of looking up a CES survey code and the associated call.
}
\details{
Items under the \emph{Survey Code Calls} and \emph{Index Code Calls} can be copied and used with the \code{get_ces()} function.
\subsection{Survey Codes}{
\itemize{
\item \code{ces2019_web} 2019 CES online survey dataset.
\item \code{ces2019_phone} 2019 CES phone survey dataset.
\item \code{ces2015_web} 2015 CES online survey dataset.
\item \code{ces2015_phone} 2015 CES phone survey dataset.
\item \code{ces2015_combo} 2015 CES combined (online/phone) dataset.
\item \code{ces2011} 2011 CES survey dataset.
\item \code{ces2008} 2008 CES survey dataset.
\item \code{ces2004} 2004 CES survey dataset.
\item \code{ces0411} 2004-2011 CES survey dataset.
\item \code{ces0406} 2004-2006 CES survey dataset.
\item \code{ces2000} 2000 CES survey dataset.
\item \code{ces1997} 1997 CES survey dataset.
\item \code{ces1993} 1993 CES survey dataset.
\item \code{ces1988} 1988 CES survey dataset.
\item \code{ces1984} 1984 CES survey dataset.
\item \code{ces1974} 1974 CES survey dataset.
\item \code{ces7480} 1974-1980 CES survey dataset.
\item \code{ces72_jnjl} 1972 June-July CES survey dataset.
\item \code{ces72_sep} 1972 September CES survey dataset.
\item \code{ces72_nov} 1972 November CES survey dataset.
\item \code{ces1968} 1968 CES survey dataset.
\item \code{ces1965} 1965 CES survey dataset.
}
}

\subsection{Survey Code Calls}{
\itemize{
\item \code{"ces2019_web"} calls 2019 CES online survey dataset.
\item \code{"ces2019_phone"} calls 2019 CES phone survey dataset.
\item \code{"ces2015_web"} calls 2015 CES online survey dataset.
\item \code{"ces2015_phone"} calls 2015 CES phone survey dataset.
\item \code{"ces2015_combo"} calls 2015 CES combined (online/phone) dataset.
\item \code{"ces2011"} calls 2011 CES survey dataset.
\item \code{"ces2008"} calls 2008 CES survey dataset.
\item \code{"ces2004"} calls 2004 CES survey dataset.
\item \code{"ces0411"} calls 2004-2011 CES survey dataset.
\item \code{"ces0406"} calls 2004-2006 CES survey dataset.
\item \code{"ces2000"} calls 2000 CES survey dataset.
\item \code{"ces1997"} calls 1997 CES survey dataset.
\item \code{"ces1993"} calls 1993 CES survey dataset.
\item \code{"ces1988"} calls 1988 CES survey dataset.
\item \code{"ces1984"} calls 1984 CES survey dataset.
\item \code{"ces1974"} calls 1974 CES survey dataset.
\item \code{"ces7480"} calls 1974-1980 CES survey dataset.
\item \code{"ces72_jnjl"} calls 1972 June-July CES survey dataset.
\item \code{"ces72_sep"} calls 1972 September CES survey dataset.
\item \code{"ces72_nov"} calls 1972 November CES survey dataset.
\item \code{"ces1968"} calls 1968 CES survey dataset.
\item \code{"ces1965"} calls 1965 CES survey dataset.
}
}
}
\examples{
# print out CES code calls
get_cescodes()

# call 1984 CES survey
get_ces("ces1984")

}
\seealso{
\code{get_ces()} function help.
}
