% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bbk.R
\name{bbk_metadata}
\alias{bbk_metadata}
\title{Fetch Deutsche Bundesbank (BBk) metadata}
\source{
\url{https://www.bundesbank.de/en/statistics/time-series-databases/help-for-sdmx-web-service/web-service-interface-metadata}
}
\usage{
bbk_metadata(type, id = NULL, lang = "en")
}
\arguments{
\item{type}{(\code{character(1)})\cr
The type of metadata to query.
One of: \code{"datastructure"}, \code{"dataflow"}, \code{"codelist"}, or \code{"concept"}.}

\item{id}{(\code{NULL} | \code{character(1)})\cr
The id to query. Default \code{NULL}.}

\item{lang}{(\code{character(1)})\cr
Language to query, either \code{"en"} or \code{"de"}. Default \code{"en"}.}
}
\value{
A \code{\link[data.table:data.table]{data.table::data.table()}} with the requested metadata.
The columns are:
\item{id}{The id of the metadata}
\item{name}{The name of the metadata}
}
\description{
Retrieve metadata from the Bundesbank time series database via the SDMX Web Service.
}
\examples{
\dontshow{if (curl::has_internet()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
bbk_metadata("datastructure")
bbk_metadata("dataflow", "BBSIS")
bbk_metadata("codelist", "CL_BBK_ACIP_ASSET_LIABILITY")
bbk_metadata("concept", "CS_BBK_BSPL")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other metadata: 
\code{\link{ecb_metadata}()},
\code{\link{onb_dimension}()},
\code{\link{onb_frequency}()},
\code{\link{onb_hierarchy}()},
\code{\link{onb_metadata}()},
\code{\link{onb_toc}()}
}
\concept{metadata}
