% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfa_trends.R
\name{dfa_trends}
\alias{dfa_trends}
\title{Get the trends from a DFA as a data frame}
\usage{
dfa_trends(rotated_modelfit, years = NULL)
}
\arguments{
\item{rotated_modelfit}{Output from \code{\link{rotate_trends}}.}

\item{years}{Optional numeric vector of years.}
}
\value{
A data frame with the following columns: \code{time} is the time step, \code{trend_number} is an identifier for each trend, \code{estimate} is the trend mean, \code{lower} is the lower CI, and \code{upper} is the upper CI.
}
\description{
Get the trends from a DFA as a data frame
}
\examples{
set.seed(1)
s <- sim_dfa(num_trends = 1)
m <- fit_dfa(y = s$y_sim, num_trends = 1, iter = 50, chains = 1)
r <- rotate_trends(m)
trends <- dfa_trends(r)
}
\seealso{
plot_trends fit_dfa rotate_trends
}
