% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bage_mod-functions.R
\name{set_seeds}
\alias{set_seeds}
\title{Reset Random Seeds in Model Object}
\usage{
set_seeds(mod, new_seeds = NULL)
}
\arguments{
\item{mod}{An object of class \code{"bage_mod"},
created with \code{\link[=mod_pois]{mod_pois()}},
\code{\link[=mod_binom]{mod_binom()}}, or \code{\link[=mod_norm]{mod_norm()}}.}

\item{new_seeds}{\code{NULL} (the default) or a list
of integers with names \code{"seed_components"}
\code{"seed_augment"}, \code{"seed_forecast_components"},
and \code{"seed_forecast_augment"}.}
}
\value{
A modified version of \code{mod}.
}
\description{
Reset random seeds stored in a model object.
When \code{new_seeds} is \code{NULL} (the default),
the new seeds are generated randomly; otherwise
they are taken from \code{new_seeds}.
}
\details{
When an object of class \code{"bage_mod"} is first created,
values are generated four four random seeds:
\itemize{
\item \code{seed_components}
\item \code{seed_augment}
\item \code{seed_forecast_components}
\item \code{seed_forecast_augment}
}

When \code{\link[=fit]{fit()}}, \code{\link[=components]{components()}}, \code{\link[=augment]{augment()}},
and \code{\link[=forecast]{forecast()}} are called on the model object,
the seeds are used internally to ensure that
he same inputs generate the same outputs, even
when the outputs involve random draws.

End users are unlikely to call \code{set_seeds()} in
a data analysis, though it may occasionally by useful
when building a simulation from scratch.
}
\examples{
## fit model
mod <- mod_pois(injuries ~ age,
                data = nzl_injuries,
                exposure = popn) |>
  fit()

## call 'components()'
components(mod)

## call 'components()' again - same results
components(mod)

## reset seeds
mod <- set_seeds(mod)

## calling 'set_seeds' unfits the model
is_fitted(mod)

## so we fit it again
mod <- fit(mod)

## when we call components, we get
## different results from earlier
components(mod)
}
\seealso{
\itemize{
\item \code{\link[=report_sim]{report_sim()}} Do a simulation study. (\code{report_sim()}
calls \code{set_seeds()} internally.)
\item \code{\link[=mod_pois]{mod_pois()}}, \code{\link[=mod_binom]{mod_binom()}}, \code{\link[=mod_norm]{mod_norm()}} Specify a model
\item \code{\link[=fit]{fit()}} Fit a model
\item \code{\link[=unfit]{unfit()}} Reset model, deleting estimates
}
}
