% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svds.R
\name{svds}
\alias{svds}
\title{Scaled SVDs}
\description{
Scaled SVDs contain information on typical age-patterns
or age-sex patterns for demographic processes,
extracted from international databases. The
information is extracted using a singular
value decomposition (SVD), and then scaled to make
it easier to formulate priors.

Scaled SVDs can have multiple versions, based
on data released at different dates, or on
subsets of the available data.

Some datasets, and hence some scaled SVDs, include information
on age but not on sex or gender.
}
\details{
\tabular{lllll}{
   \strong{Scaled SVD} \tab \strong{Process} \tab \strong{Source} \tab \strong{Versions} \tab \strong{Sex dimension} \cr
   \link{CSA} \tab School attendance \tab Census data assembled by UN \tab \code{"v2025"}, \code{"v2024"} \tab Yes \cr
   \link{HFD} \tab Fertility \tab Human Fertility Database \tab \code{"v2025"}, \code{"v2024"} \tab No \cr
   \link{HIMD_R} \tab Internal migration: annual rates \tab Human Internal Migration Database \tab \code{"v2024"} \tab No \cr
   \link{HIMD_P1} \tab Internal migration: 1-year probabilities \tab Human Internal Migration Database \tab \code{"v2024"} \tab No \cr
   \link{HIMD_P5} \tab Internal migration: 5-year probabilities \tab Human Internal Migration Database \tab \code{"v2024"} \tab No \cr
   \link{HMD} \tab Mortality \tab Human Mortality Database \tab \code{"v2025"}, \code{"v2025_50"}, \code{"v2024"} \tab Yes \cr
   \link{LFP} \tab Labour Force Participation \tab OECD \tab \code{"v2025"} \tab Yes \cr
   \link{WMD_C} \tab Currently married \tab World Migration Data \tab \code{"v2019"} \tab Yes \cr
   \link{WMD_E} \tab Ever married \tab World Migration Data \tab \code{"v2019"} \tab Yes \cr
}
}
