% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpcmdif.R
\name{gpcm_dif}
\alias{gpcm_dif}
\alias{summary.gpcmdif}
\alias{print.gpcmdif}
\title{Estimation of The Generalized Partial Credit Model with DIF}
\usage{
gpcm_dif(
  X,
  init_par = c(),
  groups_map = c(),
  setting = c(),
  method = c("fast", "novel")
)

\method{summary}{gpcmdif}(object, ...)

\method{print}{gpcmdif}(x, ...)
}
\arguments{
\item{X}{A matrix or data frame as an input with ordinal responses (starting from 0);
rows represent individuals, columns represent items.}

\item{init_par}{a vector of initial values of the estimated parameters.}

\item{groups_map}{Binary matrix. Respondents membership to DIF groups; rows represent individuals, column represent group partitions.}

\item{setting}{a list of the optimization control setting parameters.See \code{\link[autoRasch:autoRaschOptions]{autoRaschOptions()}}}

\item{method}{The implementation option of log likelihood function. \code{fast} using a \code{c++} implementation and \code{novel} using an \code{R} implementation.}

\item{object}{The object of class \code{'gpcmdif'}.}

\item{...}{Further arguments to be passed.}

\item{x}{The object of class \code{'gpcmdif'}.}
}
\value{
\item{X}{   The dataset that is used for estimation.}
\item{mt_vek}{   A vector of the highest responses given to items.}
\item{itemName}{   The vector of names of items (columns) in the dataset.}
\item{loglik}{   The log likelihood of the estimation.}
\item{hessian}{   The hessian matrix. Only when the \code{isHessian = TRUE}.}
\item{delta}{   A vector of the DIF parameters of each items on each groups.}
\item{gamma}{   A vector of the natural logarithm of discrimination parameters of each items.}
\item{beta}{   A vector of the difficulty parameter of each items' categories (thresholds).}
\item{theta}{   A vector of the ability parameters of each individuals.}
}
\description{
This function computes the parameter estimates of a generalized partial credit model with DIF for polytomous responses
by using penalized JML estimation.
}
\details{
In the discrimination parameters estimation, instead of estimating the discrimination parameters,
we are estimating the natural logarithm of the parameters to avoid negative values, \eqn{\alpha = exp(\gamma)}.
}
\examples{
\dontrun{
gpcmdif_res <- gpcm_dif(shortDIF, groups_map = c(rep(1,50),rep(0,50)))
summary(gpcmdif_res, par="delta")
}

}
\seealso{
\code{\link{pcm}}, \code{\link{pcm_dif}}, \code{\link{gpcm}}, \code{\link{gpcm_dif}}
}
