#' GPS locations of turkey vultures.
#'
#' A dataset containing a subset of the locations of turkey vultures (2003--2006), with time stamps, from:
#'
#'  Dodge S, Bohrer G, Bildstein K, Davidson SC, Weinzierl R, Mechard MJ, Barber D, Kays R, Brandes D, Han J (2014) Environmental drivers of variability in the movement ecology of turkey vultures (Cathartes aura) in North and South America. Philosophical Transactions of the Royal Society B 20130195. doi:10.1098/rstb.2013.0195
#'
#'  Bildstein K, Barber D, Bechard MJ (2014) Data from: Environmental drivers of variability in the movement ecology of turkey vultures (Cathartes aura) in North and South America. Movebank Data Repository. doi:10.5441/001/1.46ft1k05
#'
#' @format A data frame with 215719 rows and 11 variables:
#' \describe{
#'   \item{timestamp}{time of observation}
#'   \item{location.long}{logitude}
#'   \item{location.lat}{latitude}
#'   \item{individual.local.identifier}{identifier for each individual}
#'   ...
#' }
#' @source \url{doi:10.5441/001/1.46ft1k05} Bildstein K, Barber D, Bechard MJ (2014) Data from: Environmental drivers of variability in the movement ecology of turkey vultures (Cathartes aura) in North and South America. Movebank Data Repository. 
"vultures"

#' GPS locations of three species of whales.
#'
#' A dataset containing locations of whales, with time stamps, from:
#'
#'  Irvine LM, Winsor MH, Follett TM, Mate BR, Palacios DM (2020) An at-sea assessment of Argos location accuracy for three species of large whales, and the effect of deep-diving behavior on location error. Animal Biotelemetry 8:20.
#'  
#'  Irvine LM, Follett TM, Winsor MH, Mate BR, Palacios DM (2020) Data from: Study "Blue and fin whales Southern California 2014-2015 - Argos data". Movebank Data Repository. doi:10.5441/001/1.98f5r6d0  
#'
#' @format A data frame with 4303 rows and 4 variables:
#' \describe{
#'   \item{timestamp}{time of observation}
#'   \item{location.long}{logitude}
#'   \item{location.lat}{latitude}
#'   \item{individual.local.identifier}{identifier for each individual}
#'   ...
#' }
#' @source \url{doi:10.5441/001/1.98f5r6d0} Irvine LM, Follett TM, Winsor MH, Mate BR, Palacios DM (2020) Data from: Study "Blue and fin whales Southern California 2014-2015 - Argos data". Movebank Data Repository.
"whales"
