% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_var_dthcaus.R
\name{dthcaus_source}
\alias{dthcaus_source}
\title{Create a \code{dthcaus_source} Object}
\usage{
dthcaus_source(
  dataset_name,
  filter,
  date,
  order = NULL,
  mode = "first",
  dthcaus,
  set_values_to = NULL
)
}
\arguments{
\item{dataset_name}{The name of the dataset, i.e. a string, used to search for
the death cause.

\describe{
\item{Default value}{none}
}}

\item{filter}{An expression used for filtering \code{dataset}.

\describe{
\item{Default value}{none}
}}

\item{date}{A date or datetime variable or an expression to be used for
sorting \code{dataset}.

\describe{
\item{Default value}{none}
}}

\item{order}{Sort order

Additional variables/expressions to be used for sorting the \code{dataset}. The
dataset is ordered by \code{date} and \code{order}. Can be used to avoid duplicate
record warning.

\describe{
\item{Permitted values}{list of expressions created by \code{exprs()}, e.g.,
\code{exprs(ADT, desc(AVAL))} or \code{NULL}}
\item{Default value}{\code{NULL}}
}}

\item{mode}{One of \code{"first"} or \code{"last"}.
Either the \code{"first"} or \code{"last"} observation is preserved from the \code{dataset}
which is ordered by \code{date}.

\describe{
\item{Default value}{\code{"first"}}
}}

\item{dthcaus}{A variable name, an expression, or a string literal

If a variable name is specified, e.g., \code{AEDECOD}, it is the variable in the
source dataset to be used to assign values to \code{DTHCAUS}; if an expression,
e.g., \code{str_to_upper(AEDECOD)}, it is evaluated in the source dataset and
the results is assigned to \code{DTHCAUS}; if a string literal, e.g. \code{"Adverse Event"}, it is the fixed value to be assigned to \code{DTHCAUS}.

\describe{
\item{Default value}{none}
}}

\item{set_values_to}{Variables to be set to trace the source dataset

\describe{
\item{Default value}{\code{NULL}}
}}
}
\value{
An object of class "dthcaus_source".
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} The \code{dthcaus_source()}
function and \code{dthcaus_source()} have been deprecated in favor of
\code{event()}.
}
\examples{
# Deaths sourced from AE
src_ae <- dthcaus_source(
  dataset_name = "ae",
  filter = AEOUT == "FATAL",
  date = AEDTHDT,
  mode = "first",
  dthcaus = AEDECOD
)

# Deaths sourced from DS
src_ds <- dthcaus_source(
  dataset_name = "ds",
  filter = DSDECOD == "DEATH",
  date = convert_dtc_to_dt(DSSTDTC),
  mode = "first",
  dthcaus = DSTERM
)
}
\seealso{
\code{\link[=derive_var_dthcaus]{derive_var_dthcaus()}}

Other deprecated: 
\code{\link{call_user_fun}()},
\code{\link{date_source}()},
\code{\link{derive_param_extreme_record}()},
\code{\link{derive_var_dthcaus}()},
\code{\link{derive_var_extreme_dt}()},
\code{\link{derive_var_extreme_dtm}()},
\code{\link{get_summary_records}()}
}
\concept{deprecated}
\keyword{deprecated}
