% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derive_param_qtc.R
\name{derive_param_qtc}
\alias{derive_param_qtc}
\title{Adds a Parameter for Corrected QT (an ECG measurement)}
\usage{
derive_param_qtc(
  dataset,
  by_vars,
  method,
  set_values_to = default_qtc_paramcd(method),
  qt_code = "QT",
  rr_code = "RR",
  get_unit_expr,
  filter = NULL
)
}
\arguments{
\item{dataset}{Input dataset

The variables specified by the \code{by_vars} and \code{get_unit_expr} arguments are expected to be in the dataset.
\code{PARAMCD}, and \code{AVAL} are expected as well.

The variable specified by \code{by_vars} and \code{PARAMCD} must be a unique key of
the input dataset after restricting it by the filter condition (\code{filter}
argument) and to the parameters specified by \code{qt_code} and \code{rr_code}.

\describe{
\item{Default value}{none}
}}

\item{by_vars}{Grouping variables

Only variables specified in \code{by_vars} will be populated
in the newly created records.

\describe{
\item{Permitted values}{list of variables created by \code{exprs()}, e.g., \code{exprs(USUBJID, VISIT)}}
\item{Default value}{none}
}}

\item{method}{Method used to QT correction

See \code{\link[=compute_qtc]{compute_qtc()}} for details.

\describe{
\item{Permitted values}{\code{"Bazett"}, \code{"Fridericia"}, \code{"Sagie"}}
\item{Default value}{none}
}}

\item{set_values_to}{Variables to be set

The specified variables are set to the specified values for the new
observations. For example \code{exprs(PARAMCD = "MAP")} defines the parameter code
for the new parameter.

\describe{
\item{Permitted values}{List of variable-value pairs}
\item{Default value}{\code{exprs(PARAMCD = "MAP")}}
}}

\item{qt_code}{QT parameter code

The observations where \code{PARAMCD} equals the specified value are considered
as the QT interval assessments. It is expected that QT is measured in ms or
msec.

\describe{
\item{Permitted values}{character value}
\item{Default value}{\code{"QT"}}
}}

\item{rr_code}{RR parameter code

The observations where \code{PARAMCD} equals the specified value are considered
as the RR interval assessments. It is expected that RR is measured in ms or
msec.

\describe{
\item{Permitted values}{character value}
\item{Default value}{\code{"RR"}}
}}

\item{get_unit_expr}{An expression providing the unit of the parameter

The result is used to check the units of the input parameters.

\describe{
\item{Permitted values}{An expression which is evaluable in the input dataset
and results in a character value}
\item{Default value}{none}
}}

\item{filter}{Filter condition

The specified condition is applied to the input dataset before deriving the
new parameter, i.e., only observations fulfilling the condition are taken
into account.

\describe{
\item{Permitted values}{an unquoted condition, e.g., \code{AVISIT == "BASELINE"}}
\item{Default value}{\code{NULL}}
}}
}
\value{
The input dataset with the new parameter added. Note, a variable will only
be populated in the new parameter rows if it is specified in \code{by_vars}.
}
\description{
Adds a record for corrected QT using either Bazett's, Fridericia's or Sagie's
formula for each by group (e.g., subject and visit) where the source parameters
are available.

\strong{Note:} This is a wrapper function for the more generic \code{derive_param_computed()}.
}
\examples{
library(tibble)

adeg <- tribble(
  ~USUBJID,      ~PARAMCD, ~PARAM,                   ~AVAL, ~AVALU,      ~VISIT,
  "01-701-1015", "HR",     "Heart Rate (beats/min)", 70.14, "beats/min", "BASELINE",
  "01-701-1015", "QT",     "QT Duration (ms)",         370, "ms",        "WEEK 2",
  "01-701-1015", "HR",     "Heart Rate (beats/min)", 62.66, "beats/min", "WEEK 1",
  "01-701-1015", "RR",     "RR Duration (ms)",         710, "ms",        "WEEK 2",
  "01-701-1028", "HR",     "Heart Rate (beats/min)", 85.45, "beats/min", "BASELINE",
  "01-701-1028", "QT",     "QT Duration (ms)",         480, "ms",        "WEEK 2",
  "01-701-1028", "QT",     "QT Duration (ms)",         350, "ms",        "WEEK 3",
  "01-701-1028", "HR",     "Heart Rate (beats/min)", 56.54, "beats/min", "WEEK 3",
  "01-701-1028", "RR",     "RR Duration (ms)",         842, "ms",        "WEEK 2"
)

derive_param_qtc(
  adeg,
  by_vars = exprs(USUBJID, VISIT),
  method = "Bazett",
  set_values_to = exprs(
    PARAMCD = "QTCBR",
    PARAM = "QTcB - Bazett's Correction Formula Rederived (ms)",
    AVALU = "ms"
  ),
  get_unit_expr = AVALU
)

derive_param_qtc(
  adeg,
  by_vars = exprs(USUBJID, VISIT),
  method = "Fridericia",
  set_values_to = exprs(
    PARAMCD = "QTCFR",
    PARAM = "QTcF - Fridericia's Correction Formula Rederived (ms)",
    AVALU = "ms"
  ),
  get_unit_expr = extract_unit(PARAM)
)

derive_param_qtc(
  adeg,
  by_vars = exprs(USUBJID, VISIT),
  method = "Sagie",
  set_values_to = exprs(
    PARAMCD = "QTLCR",
    PARAM = "QTlc - Sagie's Correction Formula Rederived (ms)",
    AVALU = "ms"
  ),
  get_unit_expr = extract_unit(PARAM)
)
}
\seealso{
\code{\link[=compute_qtc]{compute_qtc()}}

BDS-Findings Functions for adding Parameters/Records: 
\code{\link{default_qtc_paramcd}()},
\code{\link{derive_expected_records}()},
\code{\link{derive_extreme_event}()},
\code{\link{derive_extreme_records}()},
\code{\link{derive_locf_records}()},
\code{\link{derive_param_bmi}()},
\code{\link{derive_param_bsa}()},
\code{\link{derive_param_computed}()},
\code{\link{derive_param_doseint}()},
\code{\link{derive_param_exist_flag}()},
\code{\link{derive_param_exposure}()},
\code{\link{derive_param_framingham}()},
\code{\link{derive_param_map}()},
\code{\link{derive_param_rr}()},
\code{\link{derive_param_wbc_abs}()},
\code{\link{derive_summary_records}()}
}
\concept{der_prm_bds_findings}
\keyword{der_prm_bds_findings}
