% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consolidate_metadata.R
\name{consolidate_metadata}
\alias{consolidate_metadata}
\title{Consolidate Multiple Meta Datasets Into a Single One}
\usage{
consolidate_metadata(
  datasets,
  key_vars,
  source_var = SOURCE,
  check_vars = "warning",
  check_type = "error"
)
}
\arguments{
\item{datasets}{List of datasets to consolidate

\describe{
\item{Permitted values}{A named list of datasets}
\item{Default value}{none}
}}

\item{key_vars}{Key variables

The specified variables must be a unique of all input datasets.

\describe{
\item{Permitted values}{A list of variables created by \code{exprs()}}
\item{Default value}{none}
}}

\item{source_var}{Source variable

The specified variable is added to the output dataset. It is set the name
of the dataset the observation is originating from.

\describe{
\item{Permitted values}{A symbol}
\item{Default value}{\code{SOURCE}}
}}

\item{check_vars}{Check variables?

If \code{"message"}, \code{"warning"}, or \code{"error"} is specified, a message is issued
if the variable names differ across the input datasets (\code{datasets}).

\describe{
\item{Permitted values}{\code{"none"}, \code{"message"}, \code{"warning"}, \code{"error"}}
\item{Default value}{\code{"warning"}}
}}

\item{check_type}{Check uniqueness?

If \code{"warning"} or \code{"error"} is specified, a message is issued if the key
variables (\code{key_vars}) are not a unique key in all of the input datasets
(\code{datasets}).

\describe{
\item{Permitted values}{\code{"none"}, \code{"warning"}, \code{"error"}}
\item{Default value}{\code{"error"}}
}}
}
\value{
A dataset which contains one row for each by group occurring in any
of the input datasets.
}
\description{
The purpose of the function is to consolidate multiple meta datasets into a
single one. For example, from global and project specific parameter mappings
a single lookup table can be created.
}
\details{
All observations of the input datasets are put together into a
single dataset. If a by group (defined by \code{key_vars}) exists in more than
one of the input datasets, the observation from the last dataset is
selected.
}
\examples{
library(tibble)
glob_ranges <- tribble(
  ~PARAMCD, ~ANRLO, ~ANRHI,
  "PULSE",      60,    100,
  "SYSBP",      90,    130,
  "DIABP",      60,     80
)
proj_ranges <- tribble(
  ~PARAMCD, ~ANRLO, ~ANRHI,
  "SYSBP",     100,    140,
  "DIABP",      70,     90
)
stud_ranges <- tribble(
  ~PARAMCD, ~ANRLO, ~ANRHI,
  "BMI",        18,     25
)

consolidate_metadata(
  datasets = list(
    global = glob_ranges,
    project = proj_ranges,
    study = stud_ranges
  ),
  key_vars = exprs(PARAMCD)
)
}
\seealso{
Creating auxiliary datasets: 
\code{\link{create_period_dataset}()},
\code{\link{create_query_data}()},
\code{\link{create_single_dose_dataset}()}
}
\concept{create_aux}
\keyword{create_aux}
