% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webpower.R
\name{wp.prop}
\alias{wp.prop}
\title{Statistical Power Analysis for Tests of Proportions}
\usage{
wp.prop(h = NULL, n1 = NULL, n2 = NULL, alpha = 0.05, power = NULL,
  type = c("1p", "2p", "2p2n"), alternative = c("two.sided", "less",
  "greater"))
}
\arguments{
\item{h}{Effect size of the proportion comparison. \cite{Cohen (1992)} suggested that effect size values of 0.2, 0.5, and 0.8 represent "small", "medium", and "large" effect sizes, repectively.}

\item{n1}{Sample size of the first group.}

\item{n2}{Sample size of the second group if applicable.}

\item{alpha}{Significance level chosed for the test. It equals 0.05 by default.}

\item{power}{Statistical power.}

\item{type}{Type of comparison (\code{"1p"} or \code{"2p"} or \code{"2p2n"}). The default is "1p". 
1p: one sample; 2p: two sample with equal sample size; 2p2n: two sample with unequal sample size.}

\item{alternative}{Direction of the alternative hypothesis (\code{"two.sided"} or \code{"less"} or \code{"greater"}). The default is "two.sided".}
}
\value{
An object of the power analysis.
}
\description{
Tests of proportions are a technique used to compare proportions of success or agreement in one or two samples.
The one-sample test of proportion tests the null proportion of success, usually 0.5.
The two-sample test of proportions tests the null hypothesis that the two samples are drawn from populations with the same proportion of success.
A z-test is used to evaluate whether the given difference in proportions is statistical significantly different from the null hypothesis.
The power calculation is based on the arcsine transformation of the proportion (see \cite{Cohen, 1988, p.548}).
}
\examples{
#To calculate the power for two groups of proportion with unequal sample size:
wp.prop(h=0.52,n1=35,n2=50,alternative="greater",type="2p2n")
#  Power for two-sample proportion (unequal n)
#
#       h n1 n2 alpha     power
#    0.52 35 50  0.05 0.7625743
#
#  NOTE: Sample size for each group
#  URL: http://psychstat.org/prop2p2n

#To calculate the power curve with a sequence of sample sizes:
res <- wp.prop(h=0.52,n1=seq(10,100,10),alternative="greater",type="1p")
res
#  Power for one-sample proportion test
#
#       h   n alpha     power
#    0.52  10  0.05 0.4998128
#    0.52  20  0.05 0.7519557
#    0.52  30  0.05 0.8855706
#    0.52  40  0.05 0.9499031
#    0.52  50  0.05 0.9789283
#    0.52  60  0.05 0.9914150
#    0.52  70  0.05 0.9965928
#    0.52  80  0.05 0.9986772
#    0.52  90  0.05 0.9994960
#    0.52 100  0.05 0.9998111
#
#  URL: http://psychstat.org/prop

#To plot the power curve:
plot(res, type='b')

#To estimate the sample size with a given power:
wp.prop(h=0.52,n1=NULL,power=0.8,alternative="greater",type="1p")
#  Power for one-sample proportion test
#
#       h        n alpha power
#    0.52 22.86449  0.05   0.8
#
#  URL: http://psychstat.org/prop

#To estimate the minimum detectable effect size with a given power:
wp.prop(h=NULL,n1=35,power=0.8,alternative="greater",type="1p")
#  Power for one-sample proportion test
#
#            h  n alpha power
#    0.4202907 35  0.05   0.8
#
#  URL: http://psychstat.org/prop

#To calculate the power curve with a sequence of effect sizes:
wp.prop(h=seq(0.1, 0.8, 0.1),n1=100,alternative="greater",type="1p")
#  Power for one-sample proportion test
#
#      h   n alpha     power
#    0.1 100  0.05 0.2595110
#    0.2 100  0.05 0.6387600
#    0.3 100  0.05 0.9123145
#    0.4 100  0.05 0.9907423
#    0.5 100  0.05 0.9996034
#    0.6 100  0.05 0.9999934
#    0.7 100  0.05 1.0000000
#    0.8 100  0.05 1.0000000
#
#  URL: http://psychstat.org/prop
}
\references{
Cohen, J. (1992). A power primer. Psychological bulletin, 112(1), 155.

Cohen, J. (1988). Statistical power analysis for the behavioral sciences (2nd Ed). Hillsdale, NJ: Lawrence Erlbaum Associates.

Zhang, Z., & Yuan, K.-H. (2018). Practical Statistical Power Analysis Using Webpower and R (Eds). Granger, IN: ISDSA Press.
}
