% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spectral_clustering.R
\name{SpectralClustering}
\alias{SpectralClustering}
\title{Spectral clustering}
\usage{
SpectralClustering(D, nn = 10, nEig = 2)
}
\arguments{
\item{D}{Square matrix or \code{dist} object containing Euclidean distances
between data points.}

\item{nn}{Integer specifying number of nearest neighbours to consider}

\item{nEig}{Integer specifying number of eigenvectors to retain.}
}
\description{
Spectral clustering
}
\examples{
library('TreeTools', quietly = TRUE, warn.conflict = FALSE)
trees <- as.phylo(0:10, nTip = 8)
distances <- ClusteringInfoDistance(trees)
SpectralClustering(distances)
}
\seealso{
Other tree space functions: 
\code{\link{ProjectionQuality}()},
\code{\link{Project}()},
\code{\link{median.multiPhylo}()}
}
\author{
Adapted by MRS from script by
\href{https://rpubs.com/nurakawa/spectral-clustering}{Nura Kawa}
}
\concept{tree space functions}
