% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspec.R
\name{mspec}
\alias{mspec}
\title{Preforms spectral clustering on mix typed data}
\usage{
mspec(
  z,
  k = 2,
  sigma = c(20, 20),
  c_wt = NULL,
  starts = 10,
  its = 300,
  verbose = FALSE
)
}
\arguments{
\item{z}{data to be clustered}

\item{k}{the number of clusters.}

\item{sigma}{vector of lower,upper bounds for sigma}

\item{c_wt}{the category weights, is assigned to
c(0.9999, 0.999, .99, seq(0.95, 0.05,-0.05), .01, 0.001, 0.0001)
if null.}

\item{starts}{the number of random starts}

\item{its}{the max number of iterations for the kmeans algorithm}

\item{verbose}{if you would like printed output during running of function}
}
\value{ A class SpectralClMixed list with components
\item{ct_wt}{ the selected category weight}
\item{bt/wt_ss}{ the between divided by the within sum of squares}
\item{tot_wt_ss}{the total within sum of squares}
\item{cluster}{the cluster assignments}
\item{data}{the original data}
}
\description{
Preforms spectral clustering of mix-type data
}
\references{F. Mbuga and, C. Tortora. Spectral Clustering of Mixed-Type Data. \emph{Stats}, 5(1) 2022  }
\examples{
c1=data.frame(v1=rnorm(30,0),v2=rnorm(30,0),v3=factor(round(runif(30))+1))
c2=data.frame(v1=rnorm(30,2),v2=rnorm(30,4),v3=factor(round(runif(30))+4))
data=rbind(c1,c2)
res=mspec(data, k = 2)
summary(res)
plot(res)
}
