% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sobolSequence.R
\docType{package}
\name{SobolSequence-package}
\alias{SobolSequence-package}
\alias{sobolsequence}
\title{Sobol Sequence}
\description{
R implementation of S. Joe and F. Y. Kuo,
"Constructing Sobol sequences with better two-dimensional projections",
SIAM J. Sci. Comput. 30, 2635-2654 (2008).
}
\details{
The implementation is based on the data file new-joe-kuo-6.21201
<http://web.maths.unsw.edu.au/~fkuo/sobol/>.

Porting to R by Mutsuo Saito.
The R version does not returns cordinate value zero,
but returns value very near to zero, 2^-64.
}
\section{Acknowledgments}{

I, Mutsuo Saito, wish to thank Frances Kuo and Stephen Joe for their research,
and agreement to use thier source code.

The development of this R code is partially supported by JST CREST.
}

\section{Reference}{

S. Joe and F. Y. Kuo,
"Constructing Sobol sequences with better two-dimensional projections",
SIAM J. Sci. Comput. 30, 2635-2654 (2008).
}

\examples{
srange <- sobolSequence.dimMinMax()
mrange <- sobolSequence.dimF2MinMax(srange[1])
points <- sobolSequence.points(dimR=srange[1], dimF2=mrange[1], count=10000)
points <- sobolSequence.points(dimR=srange[1], dimF2=mrange[1], count=10000,
                               digitalShift=TRUE)
}
