% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_colchina.R
\name{download_colchina}
\alias{download_colchina}
\title{Download 'Catalogue of Life China': Annual Checklist}
\usage{
download_colchina(version = "2020", OS = "MacOS", dir = tempdir())
}
\arguments{
\item{version}{\code{integer} Release version of annual checklist,the default value is 2020.}

\item{OS}{\code{character} Supported operating system,c("MacOS", "Ubuntu" ,"Windows"),the default value is "MacOS".}

\item{dir}{a non-empty character vector giving the directory name by user,the default value is dir = tempdir(),see [tempdir()] for details.}
}
\value{
URL
}
\description{
Organized by the Biodiversity Committee of Chinese Academy of Sciences (BC-CAS), Catalogue of Life China Annual Checklist edition has been compiled by Species 2000 China Node.
}
\details{
Visit the website \url{http://sp2000.org.cn/download} for more details.
}
\examples{
\donttest{
dir <- tempdir()
download_colchina(version = "2020",OS = "MacOS", dir = dir)
}
}
\author{
Liuyong Ding
}
