% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auxiliary.R
\name{aux.kernelcov}
\alias{aux.kernelcov}
\title{Build a centered kernel matrix K}
\usage{
aux.kernelcov(X, ktype)
}
\arguments{
\item{X}{an \eqn{(n\times p)} data matrix}

\item{ktype}{a vector containing the type of kernel and parameters involved. Below the usage is
consistent with description
\describe{
\item{linear}{\code{c("linear",c)}}
\item{polynomial}{\code{c("polynomial",c,d)}}
\item{gaussian}{\code{c("gaussian",c)}}
\item{laplacian}{\code{c("laplacian",c)}}
\item{anova}{\code{c("anova",c,d)}}
\item{sigmoid}{\code{c("sigmoid",a,b)}}
\item{rational quadratic}{\code{c("rq",c)}}
\item{multiquadric}{\code{c("mq",c)}}
\item{inverse quadric}{\code{c("iq",c)}}
\item{inverse multiquadric}{\code{c("imq",c)}}
\item{circular}{\code{c("circular",c)}}
\item{spherical}{\code{c("spherical",c)}}
\item{power/triangular}{\code{c("power",d)}}
\item{log}{\code{c("log",d)}}
\item{spline}{\code{c("spline")}}
\item{Cauchy}{\code{c("cauchy",c)}}
\item{Chi-squared}{\code{c("chisq")}}
\item{histogram intersection}{\code{c("histintx")}}
\item{generalized histogram intersection}{\code{c("ghistintx",c,d)}}
\item{generalized Student-t}{\code{c("t",d)}}
}}
}
\value{
a named list containing \describe{
\item{K}{a \eqn{(p\times p)} kernelizd gram matrix.}
\item{Kcenter}{a \eqn{(p\times p)} centered version of \code{K}.}
}
}
\description{
From the celebrated Mercer's Theorem, we know that for a mapping \eqn{\phi}, there exists
a kernel function - or, symmetric bilinear form, \eqn{K} such that \deqn{K(x,y) = <\phi(x),\phi(y)>} where \eqn{<,>} is
standard inner product. \code{aux.kernelcov} is a collection of 20 such positive definite kernel functions, as
well as centering of such kernel since covariance requires a mean to be subtracted and
a set of transformed values \eqn{\phi(x_i),i=1,2,\dots,n} are not centered after transformation.
Since some kernels require parameters - up to 2, its usage will be listed in arguments section.
}
\details{
There are 20 kernels supported. Belows are the kernels when given two vectors \eqn{x,y}, \eqn{K(x,y)}
\describe{
\item{linear}{\eqn{=<x,y>+c}}
\item{polynomial}{\eqn{=(<x,y>+c)^d}}
\item{gaussian}{\eqn{=exp(-c\|x-y\|^2)}, \eqn{c>0}}
\item{laplacian}{\eqn{=exp(-c\|x-y\|)}, \eqn{c>0}}
\item{anova}{\eqn{=\sum_k exp(-c(x_k-y_k)^2)^d}, \eqn{c>0,d\ge 1}}
\item{sigmoid}{\eqn{=tanh(a<x,y>+b)}}
\item{rational quadratic}{\eqn{=1-(\|x-y\|^2)/(\|x-y\|^2+c)}}
\item{multiquadric}{\eqn{=\sqrt{\|x-y\|^2 + c^2}}}
\item{inverse quadric}{\eqn{=1/(\|x-y\|^2+c^2)}}
\item{inverse multiquadric}{\eqn{=1/\sqrt{\|x-y\|^2+c^2}}}
\item{circular}{\eqn{=
\frac{2}{\pi} arccos(-\frac{\|x-y\|}{c}) - \frac{2}{\pi} \frac{\|x-y\|}{c}\sqrt{1-(\|x-y\|/c)^2}
}, \eqn{c>0}}
\item{spherical}{\eqn{=
1-1.5\frac{\|x-y\|}{c}+0.5(\|x-y\|/c)^3
}, \eqn{c>0}}
\item{power/triangular}{\eqn{=-\|x-y\|^d}, \eqn{d\ge 1}}
\item{log}{\eqn{=-\log (\|x-y\|^d+1)}}
\item{spline}{\eqn{=
\prod_i (
1+x_i y_i(1+min(x_i,y_i)) - \frac{x_i + y_i}{2} min(x_i,y_i)^2
+ \frac{min(x_i,y_i)^3}{3}
)
}}
\item{Cauchy}{\eqn{=\frac{c^2}{c^2+\|x-y\|^2}}}
\item{Chi-squared}{\eqn{=\sum_i \frac{2x_i y_i}{x_i+y_i}}}
\item{histogram intersection}{\eqn{=\sum_i min(x_i,y_i)}}
\item{generalized histogram intersection}{\eqn{=sum_i min(
|x_i|^c,|y_i|^d
)}}
\item{generalized Student-t}{\eqn{=1/(1+\|x-y\|^d)}, \eqn{d\ge 1}}
}
}
\examples{
\dontrun{
## generate data
X = aux.gensamples(n=100)

## extra parameters do not matter for no-parameter kernels
A1 = aux.kernelcov(X,c("spline"))
A2 = aux.kernelcov(X,c("spline",1,2)) # these numbers will be disregarded.
print(paste("* aux.kernelcov : abs.diff.",norm(A1$K-A2$K,"f"),"in norm"))
}


}
\references{
Hofmann, T., Scholkopf, B., and Smola, A.J. (2008) \emph{Kernel methods in
machine learning}. arXiv:math/0701907.
}
\author{
Kisung You
}
