% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.r
\name{msgpack_pack}
\alias{msgpack_pack}
\alias{msgpackPack}
\title{'MsgPack' Pack}
\usage{
msgpack_pack(...)

msgpackPack(...)
}
\arguments{
\item{...}{Any R objects that have corresponding msgpack types.}
}
\value{
A raw vector containing the message.
}
\description{
Serialize any number of objects into a single message.  Unnamed List is converted into Array, Map/Data.frame and Named Lists are converted into Maps.  Integer, Double, Character, Raw vectors and NULL are converted into Int types (depending on size), Float types, String, Raw and Nil respectively.  Raw vectors with EXT attribute are converted into Extension types.  The EXT attribute should be an integer from 0 to 127.
}
\examples{
x <- msgpack_format(1:10)
x_packed <- msgpack_pack(x)
x_unpacked <- msgpack_unpack(x_packed)
x_simplified <- msgpack_simplify(x_unpacked)
}
\seealso{
See examples/tests.r for more examples.
}
