% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_gompertz.R
\name{calc_gompertz_joint_parameters}
\alias{calc_gompertz_joint_parameters}
\title{Calculating the Gompertz model parameters for joint survival}
\usage{
calc_gompertz_joint_parameters(
  p1 = list(age = NULL, mode = NULL, dispersion = NULL),
  p2 = list(age = NULL, mode = NULL, dispersion = NULL),
  max_age = 120
)
}
\arguments{
\item{p1}{A list with \code{age}, \code{mode} and \code{dispersion} parameters
for the first person (p1).}

\item{p2}{A list with \code{age}, \code{mode} and \code{dispersion} parameters
for the second person (p2).}

\item{max_age}{A numeric. The maximum age for the Gompertz model.}
}
\value{
A list containing:
\item{data}{A data frame with survival rates for 'p1', 'p2', 'joint' survival, and the fitted Gompertz model}
\item{mode}{The mode of the joint Gompertz distribution}
\item{dispersion}{The dispersion parameter of the joint Gompertz distribution}
}
\description{
Calculating the Gompertz model parameters for joint survival
}
\examples{
calc_gompertz_joint_parameters(
  p1 = list(
    age        = 65,
    mode       = 88,
    dispersion = 10.65
  ),
  p2 = list(
    age        = 60,
    mode       = 91,
    dispersion = 8.88
  ),
  max_age = 110
)
}
