% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/QurvE-package.R
\docType{package}
\name{QurvE-package}
\alias{QurvE}
\alias{QurvE-package}
\title{QurvE: Robust and User-Friendly Analysis of Growth and Fluorescence Curves}
\description{
High-throughput analysis of growth curves and fluorescence data using three methods: linear regression, growth model fitting, and smooth spline fit. Analysis of dose-response relationships via smoothing splines or dose-response models. Complete data analysis workflows can be executed in a single step via user-friendly wrapper functions. The results of these workflows are summarized in detailed reports as well as intuitively navigable 'R' data containers. A 'shiny' application provides access to all features without requiring any programming knowledge. The package is described in further detail in Wirth et al. (2023) \doi{10.1038/s41596-023-00850-7}.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/NicWir/QurvE}
  \item \url{https://nicwir.github.io/QurvE/}
  \item Report bugs at \url{https://github.com/NicWir/QurvE/issues}
}

}
\author{
\strong{Maintainer}: Nicolas T. Wirth \email{mail.nicowirth@gmail.com} (\href{https://orcid.org/0000-0003-0799-1321}{ORCID}) [copyright holder]

Authors:
\itemize{
  \item Jonathan Funk \email{funk.jonathan21@gmail.com} (Co-developer of shiny app.)
}

Other contributors:
\itemize{
  \item Matthias Kahm (Author of 'grofit' package, whose general data structure was adopted for QurvE.) [contributor]
  \item Maik Kschischo (Author of 'grofit' package, whose general data structure was adopted for QurvE.) [contributor]
  \item Thomas Petzoldt \email{thomas.petzoldt@tu-dresden.de} (\href{https://orcid.org/0000-0002-4951-6468}{ORCID}) (Creator of the package 'growthrates', whose function for calculating linear regressions served as a template in QurvE.) [contributor]
  \item Andrew Stein \email{andy.stein@gmail.com} (Creator of 'xgxr' package from which QurvE adopted code to plot axis ticks on log10 scale.) [contributor]
  \item Michael W. Kearney \email{kearneymw@missouri.edu} (Creator of 'tfse' package from which QurvE adopted the match_arg function.) [contributor]
  \item Santiago I. Hurtado \email{santih@carina.fcaglp.unlp.edu.ar} (Creator of 'RobustLinearReg' package from which QurvE adopted the Theil Sehn Regression method.) [contributor]
  \item Mark Heckmann (Creator of the 'zipFastener' function; source: https://ryouready.wordpress.com/2009/03/27/r-zip-fastener-for-two-data-frames-combining-rows-or-columns-of-two-dataframes-in-an-alternating-manner/) [contributor]
  \item Nicholas Hamilton (Creator of the 'colFmt' function.) [contributor]
  \item Evan Friedland (Creator of the 'inflect' function.) [contributor]
  \item Heather Turner (Creator of the 'base_breaks' function.) [contributor]
  \item Georgi N. Boshnakov \email{georgi.boshnakov@manchester.ac.uk} (Creator of 'gbRd' package from which functions are used to display function help pages within the shiny app.) [contributor]
}

}
\keyword{internal}
