% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/participation.R
\name{participation}
\alias{participation}
\title{Participation Coefficient}
\usage{
participation(A, comm = c("walktrap", "louvain"))
}
\arguments{
\item{A}{Network adjacency matrix}

\item{comm}{A vector of corresponding to each item's community.
Defaults to \code{"walktrap"} for the \code{\link[igraph]{cluster_walktrap}} community detection algorithm.
Set to \code{"louvain"} for the \code{\link[NetworkToolbox]{louvain}} community detection algorithm.
Can also be set to user-specified communities (see examples)}
}
\value{
Returns a list containing:

\item{overall}{Participation coefficient without signs considered}

\item{positive}{Participation coefficient with only positive sign}

\item{negative}{Participation coefficient wih only negative sign}
}
\description{
Computes the participation coefficient for each node. The participation
coefficient measures the strength of a node's connections within its community. Positive
and negative signed weights for participation coefficients are computed separately.
}
\details{
Values closer to 1 suggest greater within-community connectivity and 
values closer to 0 suggest greater between-community connectivity
}
\examples{
#theoretical factors
comm <- c(rep(1,8), rep(2,8), rep(3,8), rep(4,8), rep(5,8), rep(6,8))

A <- TMFG(neoOpen)$A

pc <- participation(A, comm = comm)

#walktrap factors
wpc <- participation(A, comm = "walktrap")

}
\references{
Guimera, R., & Amaral, L. A. N. (2005).
Functional cartography of complex metabolic networks.
\emph{Nature}, \emph{433}, 895-900.
doi: \href{https://doi.org/10.1038/nature03288}{10.1038/nature03288}

Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
doi: \href{https://doi.org/10.1016/j.neuroimage.2009.10.003}{10.1016/j.neuroimage.2009.10.003}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
