% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LPM.ratio}
\alias{LPM.ratio}
\title{Lower Partial Moment Ratio}
\usage{
LPM.ratio(degree, target, variable)
}
\arguments{
\item{degree}{numeric; degree = 0 gives frequency (CDF), degree = 1 gives area.}

\item{target}{numeric vector; threshold(s). Defaults to mean(variable).}

\item{variable}{numeric vector or data‑frame column to evaluate.}
}
\value{
Numeric vector of standardized lower partial moments.
}
\description{
This function generates a standardized univariate lower partial moment
  of any non‑negative degree for a given target.
}
\examples{
  set.seed(123)
  x <- rnorm(100)
  LPM.ratio(0, mean(x), x)
\dontrun{
  plot(sort(x), LPM.ratio(0, sort(x), x))
  plot(sort(x), LPM.ratio(1, sort(x), x))
}
}
\references{
Viole, F. & Nawrocki, D. (2013) *Nonlinear Nonparametric Statistics: Using Partial Moments* (ISBN:1490523995)

Viole, F. (2017) Continuous CDFs and ANOVA with NNS. \doi{10.2139/ssrn.3007373}
}
\author{
Fred Viole, OVVO Financial Systems
}
