% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GraphicalOutputs.R
\name{IRFandGIRFgraphs}
\alias{IRFandGIRFgraphs}
\title{IRF and GIRF graphs for all models}
\usage{
IRFandGIRFgraphs(
  ModelType,
  NumOut,
  WishPdynamicsgraphs,
  WishYieldsgraphs,
  IRFhoriz,
  PathsGraphs,
  OutputType,
  Economies,
  Folder2save,
  verbose
)
}
\arguments{
\item{ModelType}{A character vector indicating the  estimated model type}

\item{NumOut}{list of computed outputs containing the model fit, IRFs, FEVDs, GIRFs, GFEVDs and perm premia}

\item{WishPdynamicsgraphs}{binary variable: set 1, if the user wishes graphs to be generated; or set 0, otherwise}

\item{WishYieldsgraphs}{binary variable: set 1, if the user wishes graphs to be generated; or set 0, otherwise}

\item{IRFhoriz}{single numerical vector containing the desired horizon of analysis for the IRFs}

\item{PathsGraphs}{Path of the folder in which the graphs will be saved}

\item{OutputType}{Available options are 'IRF' and 'GIRF'}

\item{Economies}{A character vector containing the names of the economies included in the system.}

\item{Folder2save}{Folder path where the outputs will be stored.}

\item{verbose}{Logical flag controlling function messaging.}
}
\description{
IRF and GIRF graphs for all models
}
\section{Available Methods}{

- `autoplot(object, type = "IRF_Factor")`, `autoplot(object, type = "IRF_Yields")`,
  `autoplot(object, type = "GIRF_Yields")`, `autoplot(object, type = "GIRF_Yields")`. \cr

 - For JLL-based models other option available are: `autoplot(object, type = "IRF_Factor-_Ortho")`,
 `autoplot(object, type = "IRF_Yields_Ortho")`, `autoplot(object, type = "GIRF_Yields_Ortho")`,
  `autoplot(object, type = "GIRF_Yields_Ortho")`.
}

\examples{
data("NumOutEx")
ModelType <- "JPS original"
Economy <- "Brazil"
IRFhoriz <- 20
IRFandGIRFgraphs(ModelType, NumOutEx, WishPdynamicsgraphs = 0, WishYieldsgraphs = 1, IRFhoriz,
                PathsGraphs = NULL, OutputType = "GIRF", Economy, Folder2save = NULL,
                verbose = FALSE)

}
