% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor.test_eq.R
\name{cor.test_eq}
\alias{cor.test_eq}
\title{Test for no correlation between paired sampes}
\usage{
cor.test_eq(x, y, B = 10000)
}
\arguments{
\item{x}{first \code{vector} to be compared (or two column \code{matrix/data.frame}).}

\item{y}{second \code{vector} to be compared (ommit if included in \code{x}).}

\item{B}{integer number of permutations, default = 10000.}
}
\value{
A value indicating if the two input vectors are signficantly different.
}
\description{
Permutation test for squared Pearson correlation between to vectors of samples.
}
\details{
This is a convenience function combining \code{SMI} and \code{significant} for the
special case of vector vs vector comparisons. The nullhypothesis is that the correlation
between the vectors is +/-1, while significance signifies a deviance toward 0.
}
\examples{
a <- (1:5) + rnorm(5)
b <- (1:5) + rnorm(5)
cor.test_eq(a,b)

}
\references{
Similarity of Matrices Index - Ulf Geir Indahl, Tormod Næs, Kristian Hovde Liland
}
\seealso{
\code{\link{plot.SMI}} (print.SMI/summary.SMI), \code{\link{RV}} (RV2/RVadj), \code{\link{r1}} (r2/r3/r4/GCD), 
\code{\link{allCorrelations}} (matrix correlation comparison), \code{\link{PCAcv} (cross-validated PCA)}.
}
\author{
Kristian Hovde Liland
}
