% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot}
\alias{plot}
\alias{plot.Calibration}
\alias{plot.ConfusionList}
\alias{plot.ConfusionMatrix}
\alias{plot.LiftCurve}
\alias{plot.MLModel}
\alias{plot.PartialDependence}
\alias{plot.Performance}
\alias{plot.PerformanceCurve}
\alias{plot.Resample}
\alias{plot.TrainingStep}
\alias{plot.VariableImportance}
\title{Model Performance Plots}
\usage{
\method{plot}{Calibration}(x, type = c("line", "point"), se = FALSE, ...)

\method{plot}{ConfusionList}(x, ...)

\method{plot}{ConfusionMatrix}(x, ...)

\method{plot}{LiftCurve}(
  x,
  find = numeric(),
  diagonal = TRUE,
  stat = MachineShop::settings("stat.Curve"),
  ...
)

\method{plot}{MLModel}(
  x,
  metrics = NULL,
  stat = MachineShop::settings("stat.TrainingParams"),
  type = c("boxplot", "density", "errorbar", "line", "violin"),
  ...
)

\method{plot}{PartialDependence}(x, stats = NULL, ...)

\method{plot}{Performance}(
  x,
  metrics = NULL,
  stat = MachineShop::settings("stat.Resample"),
  type = c("boxplot", "density", "errorbar", "violin"),
  ...
)

\method{plot}{PerformanceCurve}(
  x,
  type = c("tradeoffs", "cutoffs"),
  diagonal = FALSE,
  stat = MachineShop::settings("stat.Curve"),
  ...
)

\method{plot}{Resample}(
  x,
  metrics = NULL,
  stat = MachineShop::settings("stat.Resample"),
  type = c("boxplot", "density", "errorbar", "violin"),
  ...
)

\method{plot}{TrainingStep}(
  x,
  metrics = NULL,
  stat = MachineShop::settings("stat.TrainingParams"),
  type = c("boxplot", "density", "errorbar", "line", "violin"),
  ...
)

\method{plot}{VariableImportance}(x, n = Inf, ...)
}
\arguments{
\item{x}{\link{calibration}, \link{confusion}, \link{lift},
trained model \link{fit}, partial \link{dependence}, \link{performance},
\link[=curves]{performance curve}, \link{resample}, \link{rfe}, or
\link[=varimp]{variable importance} result.}

\item{type}{type of plot to construct.}

\item{se}{logical indicating whether to include standard error bars.}

\item{...}{arguments passed to other methods.}

\item{find}{numeric true positive rate at which to display reference lines
identifying the corresponding rates of positive predictions.}

\item{diagonal}{logical indicating whether to include a diagonal reference
line.}

\item{stat}{function or character string naming a function to compute a
summary statistic on resampled metrics for trained \code{MLModel} line
plots and \code{Resample} model ordering.  The original ordering is
preserved if a value of \code{NULL} is given.  For \code{LiftCurve} and
\code{PerformanceCurve} classes, plots are of resampled metrics aggregated
by the statistic if given or of resample-specific metrics if \code{NULL}.}

\item{metrics}{vector of numeric indexes or character names of performance
metrics to plot.}

\item{stats}{vector of numeric indexes or character names of partial
dependence summary statistics to plot.}

\item{n}{number of most important variables to include in the plot.}
}
\description{
Plot measures of model performance and predictor variable importance.
}
\examples{
\donttest{
## Requires prior installation of suggested package gbm to run

## Factor response example

fo <- Species ~ .
control <- CVControl()

gbm_fit <- fit(fo, data = iris, model = GBMModel, control = control)
plot(varimp(gbm_fit))

gbm_res1 <- resample(fo, iris, GBMModel(n.trees = 25), control)
gbm_res2 <- resample(fo, iris, GBMModel(n.trees = 50), control)
gbm_res3 <- resample(fo, iris, GBMModel(n.trees = 100), control)
plot(gbm_res3)

res <- c(GBM1 = gbm_res1, GBM2 = gbm_res2, GBM3 = gbm_res3)
plot(res)
}

}
