% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Class_definitions.R
\docType{class}
\name{Hist-class}
\alias{Hist-class}
\title{Class \code{'Hist'}}
\description{
An object for storing information generated by the end of the historical simulations
}
\section{Slots}{

\describe{
\item{\code{Data}}{The Data object at the end of the historical period}

\item{\code{OMPars}}{A numeric data.frame with nsim rows with sampled Stock, Fleet,
Obs, and Imp parameters.}

\item{\code{AtAge}}{A named list with arrays of dimensions: \code{c(nsim, maxage+1, nyears+proyears)} or
\code{c(nsim, maxage+1, nyears, nareas)}
\itemize{
\item Length: Length-at-age for each simulation, age, and year
\item Weight: Weight-at-age for each simulation, age, and year
\item Select: Selectivity-at-age for each simulation, age, and year
\item Retention: Retention-at-age for each simulation, age, and year
\item Maturity: Maturity-at-age for each simulation, age, and year
\item N.Mortality: Natural mortality-at-age for each simulation, age, and year
\item Z.Mortality: Total mortality-at-age for each simulation, age, year and area
\item F.Mortality: Fishing mortality-at-age for each simulation, age, year and area
\item Fret.Mortality: Fishing mortality-at-age for retained fish for each
simulation, age, year and area
\item Number: Total numbers by simulation, age, year and area
\item Biomass: Total biomass by simulation, age, year and area
\item VBiomass: Vulnerable biomass by simulation, age, year and area
\item SBiomass: Spawning biomass by simulation, age, year and area
\item Removals: Removals (biomass) by simulation, age, year and area
\item Landings: Landings (biomass) by simulation, age, year and area
\item Discards: Discards (biomass) by simulation, age, year and area
}}

\item{\code{TSdata}}{A named list with population and fleet dynamics:
\itemize{
\item Number: Total numbers; array dimensions \code{c(nsim, nyears, nareas)}
\item Biomass: Total biomass; array dimensions \code{c(nsim, nyears, nareas)}
\item VBiomass: Vulnerable biomass; array dimensions \code{c(nsim, nyears, nareas)}
\item SBiomass: Spawning Biomass; array dimensions \code{c(nsim, nyears, nareas)}
\item Removals: Removals (biomass); array dimensions \code{c(nsim, nyears, nareas)}
\item Landings: Landings (biomass); array dimensions \code{c(nsim, nyears, nareas)}
\item Discards: Discards (biomass); array dimensions \code{c(nsim, nyears, nareas)}
\item Find: Historical fishing mortality (scale-free); matrix dimensions \code{c(nsim, nyears)}
\item RecDev: Recruitment deviations (historical and projection); matrix dimensions \code{c(nsim, nyears+proyears+maxage)}
\item SPR: Named list with Equilibrium and Dynamic SPR (both matrices iwth dimensions \code{c(nsim, nyears)})
\item Unfished_Equilibrium: A named list with unfished equilibrium numbers and biomass-at-age
}}

\item{\code{Ref}}{A named list with biological reference points:
\itemize{
\item ByYear: A named list with asymptotic reference points (i.e., calculated annually without recruitment deviations) all matrices with dimensions \code{nsim} by \code{nyears+proyears}:
\itemize{
\item N0: Asymptotic unfished total number
\item SN0: Asymptotic unfished spawning number
\item B0: Asymptotic unfished total biomass
\item SSB0: Asymptotic unfished spawning biomass
\item VB0: Asymptotic unfished vulnerable biomass
\item MSY: Asymptotic MSY
\item FMSY: Fishing mortality corresponding with asymptotic MSY
\item SSBMSY: Spawning stock biomass corresponding with asymptotic MSY
\item BMSY: total biomass corresponding with asymptotic MSY
\item VBMSY: Vulnerable biomass corresponding with asymptotic MSY
\item F01: Fishing mortality where the change in yield per recruit is 10\% of that at F = 0
\item Fmax: Fishing mortality that maximizes yield per recruit
\item F_SPR: Fishing mortality corresponding to spawning potential ratio of 20 - 60\% in increments of 5\%; array dimensions \code{c(nsim, 9, nyears+proyears)}
\item Fcrash: Fishing mortality corresponding to the recruits-per-spawner at the origin of the stock-recruit relationship
\item Fmed: Fishing mortality corresponding to the median recruits-per-spawner in the historical period
\item SPRcrash: SPR corresponding to the recruits-per-spawner at the origin of the stock-recruit relationship
}
\item Dynamic_Unfished: A named list with dynamic unfished reference points for each simulation and year:
\itemize{
\item N0: Unfished total numbers
\item B0: Unfished total biomass
\item SN0: Unfished spawning numbers
\item SSB0: Unfished spawning biomass
\item VB0: Unfished vulnerable biomass
\item Rec: Unfished recruitment
}
\item ReferencePoints: A data.frame with \code{nsim} rows with with biological reference points
calculated as an average over age-of-maturity \code{ageM} years around the
current year (i.e. \code{nyears}):
\itemize{
\item N0: Average unfished numbers
\item B0: Average unfished biomass
\item SSB0: Average unfished spawning biomass (used to calculate depletion)
\item SSN0: Average unfished spawning numbers
\item VB0: Average unfished vulnerable biomass (used to calculate depletion if \code{cpar$control$D='VB'})
\item MSY: Average maximum sustainable yield (equilibrium)
\item FMSY: Average fishing mortality corresponding with MSY
\item SSBMSY: Average spawning stock biomass corresponding with MSY
\item BMSY: Average total biomass corresponding with MSY
\item VBMSY: Average vulnerable biomass corresponding with MSY
\item UMSY: Average exploitation rate corresponding with MSY
\item FMSY_M: Average FMSY/M ratio
\item SSBMSY_SSB0: Average ratio of SSBMSY to SSB0
\item BMSY_B0: Average ratio of BMSY to B0
\item VBMSY_VB0: Average ratio of VBMSY to VB0
\item RefY: Maximum yield obtained in forward projections with a fixed F
}
}}

\item{\code{SampPars}}{A named list with all sampled Stock, Fleet, Obs, and Imp parameters}

\item{\code{OM}}{The \code{OM} object (without cpars)}

\item{\code{Misc}}{A list for additional information}
}}

\author{
A. Hordyk
}
\keyword{classes}
