% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\name{ExampleData.RF70Curves}
\alias{ExampleData.RF70Curves}
\alias{RF70Curves}
\title{RF70 Example data as \linkS4class{RLum.Analysis} objects}
\format{
\code{BDX16648}: \linkS4class{RLum.Analysis} with two IR-RF curves as \linkS4class{RLum.Data.Curve} objects
}
\source{
\strong{RF70Curves}

\tabular{ll}{
Lab: \tab IRAMAT-CRP2A, CNRS-Université Bordeaux Montaigne, Bordeaux, France\cr
Lab-Code: \tab BDX16648\cr
Location: \tab Médoc, France (details see reference)\cr
Material: \tab K-feldspar (100-200 \eqn{\mu}m)\cr
Reference: \tab Kreutzer et al. (2018)
}
}
\description{
Collection two curves from Kreutzer et al. (2018) measured using the RF70 protocol
(Frouin et al., 2017) as \linkS4class{RLum.Analysis} objects.
}
\section{Version}{
 0.1.0
}

\examples{

##load data
data(ExampleData.RF70Curves, envir = environment())

##plot data
plot_RLum(RF70Curves)

}
\references{
Frouin, M., Huot, S., Kreutzer, S., Lahaye, C., Lamothe, M., Philippe, A., Mercier, N., 2017. An improved
radiofluorescence single-aliquot regenerative dose protocol for K-feldspars. Quaternary Geochronology 38, 13–24.
\doi{10.1016/j.quageo.2016.11.004}

Kreutzer, S., Duval, M., Bartz, M., Bertran, P., Bosq, M., Eynaud, F., Verdin, F., Mercier, N., 2018.
Deciphering long-term coastal dynamics using IR-RF and ESR dating: A case study from Médoc,
south-West France. Quaternary Geochronology 48, 108–120. \doi{10.1016/j.quageo.2018.09.005}
}
\keyword{datasets}
\keyword{internal}
