\name{primary_peak_analyzer}
\alias{primary_peak_analyzer}
\title{
Primary peak analyzer
}
\description{
This function performs the first round of the chromatography analysis.
}
\usage{
primary_peak_analyzer(spec_scan, index_xic, scan_tol,
spectraList, RetentionTime, mass_accuracy_xic,
smoothing_window, peak_resolving_power, min_nIsoPair,
min_peak_height, min_ratio_IsoPair, max_rpw, min_snr_baseline,
max_R13C_integrated_peak, max_percentage_missing_scans,
n_spline)
}
\arguments{
  \item{spec_scan}{
a matrix consists of 5 columns. The column contents are the m/z of 12C isotopologues, intensity of 12C isotopologues, scan number (t), m/z of 13C isotopologues, and intensity of 13C isotopologues.
}
  \item{index_xic}{
a list of indices of candidate 12C m/z values from spec_scan matrix.
}
  \item{scan_tol}{
scan tolerance to extend the chromatogram for better calculations.
}
  \item{spectraList}{
a list of mass spectra in each chromatogram scan.
}
  \item{RetentionTime}{
a vector of retention times vs. corresponding scan numbers.
}
  \item{mass_accuracy_xic}{
a m/z value to perform chromatography analysis.
}
  \item{smoothing_window}{
number of scans for peak smoothing.
}
  \item{peak_resolving_power}{
a value to represent peak resolving power.
}
  \item{min_nIsoPair}{
minimum number of nIsoPair for an individual peak.
}
  \item{min_peak_height}{
minimum peak height for an individual peak.
}
  \item{min_ratio_IsoPair}{
minimum ratio of nIsoPair per number of available scans within an individual
peak.
}
  \item{max_rpw}{
maximum allowed value of ratio of peak width at half-height to baseline (RPW) for an individual peak.
}
  \item{min_snr_baseline}{
minimum S/N baseline for an individual peak.
}
  \item{max_R13C_integrated_peak}{
maximum allowed value of average R13C for an individual peak.
}
  \item{max_percentage_missing_scans}{
maximum allowed value of percentage missing scans on the raw chromatogram for an individual peak.
}
  \item{n_spline}{
number of points for further smoothing using a cubic spline smoothing method.
}
}
\value{
a data frame consisting of 24 columns representing chromatography and mass spectrometry parameters. Each row represents an individual separated chromatographic peak.
}
