% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SAtree.R
\name{SAtree.from.fossils}
\alias{SAtree.from.fossils}
\title{Transforms a tree and fossils dataframe to a combined SA tree.
Sampled ancestors are represented as tips on zero-length edges to maintain compatibility with the ape format.
Tip labels are set to "species id"_"index", where the most recent tip of a given species receives index 1 and indices increase towards the past.}
\usage{
SAtree.from.fossils(tree, fossils)
}
\arguments{
\item{tree}{Phylo object.}

\item{fossils}{Fossils object.}
}
\value{
A list of `tree`, the SA tree integrating the fossils, and `fossils`, the fossils object updated with the tip label of each sample.
}
\description{
Transforms a tree and fossils dataframe to a combined SA tree.
Sampled ancestors are represented as tips on zero-length edges to maintain compatibility with the ape format.
Tip labels are set to "species id"_"index", where the most recent tip of a given species receives index 1 and indices increase towards the past.
}
\examples{
# simulate tree
t = ape::rtree(6)

# simulate fossils
f = sim.fossils.poisson(rate = 2, tree = t)

# transform format
t2 = SAtree.from.fossils(t,f)
plot(t2$tree)
}
