% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LikelihoodApproximation.R
\name{detectApproximationType}
\alias{detectApproximationType}
\title{Detect the type of likelihood approximation based on the data format}
\usage{
detectApproximationType(data, verbose = TRUE)
}
\arguments{
\item{data}{The approximation data. Can be a single approximation, or approximations
from multiple sites.}

\item{verbose}{Should the detected type be communicated to the user?}
}
\value{
A character vector with one of the following values: "normal", "custom", "skew normal",
"pooled", "grid", or "adaptive grid".
}
\description{
Detect the type of likelihood approximation based on the data format
}
\examples{
detectApproximationType(data.frame(logRr = 1, seLogRr = 0.1))

}
