% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_data.R
\name{plot_density}
\alias{plot_density}
\title{Plot Defective Densities}
\usage{
plot_density(
  input,
  post_predict = NULL,
  prior_predict = NULL,
  subject = NULL,
  quants = c(0.025, 0.975),
  functions = NULL,
  factors = NULL,
  defective_factor = "R",
  n_cores = 1,
  n_post = 50,
  layout = NA,
  to_plot = c("data", "posterior", "prior")[1:2],
  use_lim = c("data", "posterior", "prior")[1:2],
  legendpos = c("topright", "top"),
  posterior_args = list(),
  prior_args = list(),
  ...
)
}
\arguments{
\item{input}{Either an \code{emc} object or a data frame, or a \emph{list} of such objects.}

\item{post_predict}{Optional posterior predictive data (matching columns) or \emph{list} thereof.}

\item{prior_predict}{Optional prior predictive data (matching columns) or \emph{list} thereof.}

\item{subject}{Subset the data to a single subject (by index or name).}

\item{quants}{Numeric vector of credible interval bounds (e.g. \code{c(0.025, 0.975)}).}

\item{functions}{A function (or list of functions) that create new columns in the datasets or predictives}

\item{factors}{Character vector of factor names to aggregate over;
defaults to plotting full data set ungrouped by factors if \code{NULL}.}

\item{defective_factor}{Name of the factor used for the defective CDF (default "R").}

\item{n_cores}{Number of CPU cores to use if generating predictives from an \code{emc} object.}

\item{n_post}{Number of posterior draws to simulate if needed for predictives.}

\item{layout}{Numeric vector used in \code{par(mfrow=...)}; use \code{NA} for auto-layout.}

\item{to_plot}{Character vector: any of \code{"data"}, \code{"posterior"}, \code{"prior"}.}

\item{use_lim}{Character vector controlling which source(s) define \code{xlim}.}

\item{legendpos}{Character vector controlling the positions of the legends}

\item{posterior_args}{Optional list of graphical parameters for posterior lines/ribbons.}

\item{prior_args}{Optional list of graphical parameters for prior lines/ribbons.}

\item{...}{Other graphical parameters for the real data lines.}
}
\description{
Plots panels that contain a set of densities for each level of the specified defective factor in the data.
These densities are defective; their areas are relative to the respective
proportions of the defective factor levels. Across all levels, the area sums to 1.
Optionally, posterior/prior predictive densities can be overlaid.
}
\examples{
# Plot defective densities for each subject and the factor combination in the design:
plot_density(forstmann)
# or for one subject:
plot_density(forstmann, subject = 1)
# Now collapsing across subjects and using a different defective factor:
plot_density(forstmann, factors = "S", defective_factor = "E")
# Or plot posterior predictives
plot_density(samples_LNR, n_post = 10)
}
