% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale1.R
\name{scale1}
\alias{scale1}
\title{A variation over the base \code{R} scale function 
that avoids the "divide by 0 = NA"  problem.}
\usage{
scale1(x, scale = TRUE, center = TRUE)
}
\arguments{
\item{x}{a vector to be scaled}

\item{scale}{(default = \code{TRUE}), when \code{TRUE}
scale the vector to norm 1,
 otherwise do nothing.}

\item{center}{(default = \code{TRUE}), when \code{TRUE}
center the vectors (i.e., substract the mean from all numbers),
 otherwise do nothing.}
}
\value{
a centered (if required) and norm-1 
(if required) normalized
 vector.
}
\description{
\code{scale1}: A variation over the base 
\code{R} \code{scale} function.
 The function \code{scale1}: 
 centers (if needed) and scales a vector
 to norm 1; if the vector contains values all equal to a
 constant, \code{scale1} sets all values to 0
 (in lieu of NA as \code{scale} does). 
 Usefull when pre-processing tables
 for PCA-like type of analyses.
}
\examples{
 toto   <- runif(10)     # 10 random numbers between 0 and 1
 tutu   <- scale1(toto)  # toto centered and normalized
 toto0  <- rep(1,10)     # 10 numbers all equal to 1
 tutu0  <- scale1(toto0) # scaled to 0 # Compare with
 tutuNA <- scale(toto0)  # all numbers set to NA

}
\author{
Hervé Abdi
}
