% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{pbc_mayo_survival_df}
\alias{pbc_mayo_survival_df}
\title{Mayo Clinic Primary Biliary Cirrhosis}
\format{
A data frame with 1945 observations and 16 variables:
\describe{
  \item{ID}{Integer patient identifier}
  \item{Time}{Numeric time measurement}
  \item{death}{Numeric death indicator}
  \item{obstime}{Numeric observation time}
  \item{serBilir}{Numeric serum bilirubin measurement}
  \item{albumin}{Numeric serum albumin measurement}
  \item{alkaline}{Integer alkaline phosphatase level}
  \item{platelets}{Integer platelet count}
  \item{drug}{Factor with 2 levels indicating treatment group}
  \item{age}{Numeric age in years}
  \item{gender}{Factor with 2 levels indicating patient sex}
  \item{ascites}{Factor with 2 levels indicating presence of ascites}
  \item{hepatom}{Factor with 2 levels indicating presence of hepatomegaly}
  \item{start}{Numeric start time for interval}
  \item{stop}{Numeric stop time for interval}
  \item{event}{Numeric event indicator}
}
}
\source{
Data taken from the \pkg{JSM} package version 1.0.1.
}
\usage{
data(pbc_mayo_survival_df)
}
\description{
This dataset, pbc_mayo_survival_df, is a data frame containing data from a randomized
control trial conducted at Mayo Clinic from 1974 to 1984, studying the progression of
primary biliary cirrhosis. The dataset includes both survival and longitudinal measurements
with 1945 observations across 16 clinical variables.
}
\details{
The dataset name has been kept as 'pbc_mayo_survival_df' to avoid confusion with other
datasets in the R ecosystem. This naming convention helps distinguish this dataset as part of the
DigestiveDataSets package and assists users in identifying its specific characteristics.
The suffix 'df' indicates that the dataset is a data frame. The original content has not been
modified in any way.
}
