/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.widgets.DeducerWidget;

public class ObjectChooserWidget
extends JPanel
implements DeducerWidget,
WindowListener {
    private JLabel titleLabel;
    private JComboBox objectCombo;
    private String title = null;
    private boolean show = true;
    private String clss = "NULL";
    private boolean includeInherited = true;
    public static Color labelColor = new Color(90, 90, 90);
    String initialModel = null;
    String lastModel = null;

    public ObjectChooserWidget(String string, Window window) {
        this.initGUI();
        this.title = string;
        if (string == null) {
            this.show = false;
        } else {
            this.titleLabel.setText(string);
        }
        this.resetLayout();
        window.addWindowListener(this);
    }

    public ObjectChooserWidget(Window window) {
        this(null, window);
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.setLayout((LayoutManager)anchorLayout);
            this.setPreferredSize(new Dimension(187, 47));
            this.titleLabel = new JLabel();
            this.add((Component)this.titleLabel, new AnchorConstraint(0, 1000, 22, 0, 1, 1, 0, 1));
            this.titleLabel.setText("title");
            this.titleLabel.setPreferredSize(new Dimension(187, 20));
            this.titleLabel.setBounds(0, 0, 187, 20);
            this.titleLabel.setVerticalAlignment(3);
            this.titleLabel.setForeground(labelColor);
            this.objectCombo = new JComboBox();
            this.add((Component)this.objectCombo, new AnchorConstraint(22, 1000, 1000, 0, 2, 1, 1, 1));
            this.objectCombo.setPreferredSize(new Dimension(186, 19));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void resetLayout() {
        if (this.title == null || !this.show) {
            this.remove(this.titleLabel);
            this.remove(this.objectCombo);
            this.setPreferredSize(new Dimension(187, 29));
            this.add((Component)this.objectCombo, new AnchorConstraint(0, 1000, 1000, 0, 2, 1, 1, 1));
            this.objectCombo.setPreferredSize(new Dimension(186, 19));
        } else {
            this.remove(this.titleLabel);
            this.remove(this.objectCombo);
            this.setPreferredSize(new Dimension(187, 47));
            this.add((Component)this.titleLabel, new AnchorConstraint(0, 1000, 22, 0, 1, 1, 0, 1));
            this.titleLabel.setPreferredSize(new Dimension(187, 20));
            this.titleLabel.setBounds(0, 0, 187, 20);
            this.titleLabel.setVerticalAlignment(3);
            this.add((Component)this.objectCombo, new AnchorConstraint(22, 1000, 1000, 0, 2, 1, 1, 1));
            this.objectCombo.setPreferredSize(new Dimension(186, 19));
        }
    }

    public JLabel getLabel() {
        return this.titleLabel;
    }

    public JComboBox getComboBox() {
        return this.objectCombo;
    }

    public void refreshObjects() {
        block11: {
            try {
                int n;
                int n2;
                String[] stringArray;
                Object object;
                try {
                    object = "get.objects(" + this.getClassFilter() + ",includeInherited=" + (this.isIncludeInherited() ? "TRUE" : "FALSE") + ")";
                    stringArray = Deducer.timedEval((String)object).asStrings();
                }
                catch (Exception exception) {
                    stringArray = new String[]{};
                }
                object = this.objectCombo.getActionListeners();
                DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>(stringArray);
                String string = (String)this.objectCombo.getSelectedItem();
                for (n2 = 0; n2 < ((ActionListener[])object).length; ++n2) {
                    this.objectCombo.removeActionListener(object[n2]);
                }
                n2 = 0;
                for (n = 0; n < stringArray.length; ++n) {
                    if (!stringArray[n].equals(string)) continue;
                    n2 = 1;
                }
                if (n2 != 0) {
                    this.objectCombo.setModel(defaultComboBoxModel);
                    this.objectCombo.setSelectedItem(string);
                    for (n = 0; n < ((ActionListener[])object).length; ++n) {
                        this.objectCombo.addActionListener(object[n]);
                    }
                    break block11;
                }
                this.objectCombo.setModel(defaultComboBoxModel);
                for (n = 0; n < ((ActionListener[])object).length; ++n) {
                    this.objectCombo.addActionListener(object[n]);
                }
                try {
                    this.objectCombo.setSelectedIndex(0);
                }
                catch (Exception exception) {
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void setClassFilter(String string) {
        this.clss = string.equals("NULL") ? "NULL" : "\"" + string + "\"";
    }

    public String getClassFilter() {
        return this.clss;
    }

    public void setIncludeInherited(boolean bl) {
        this.includeInherited = bl;
    }

    public boolean isIncludeInherited() {
        return this.includeInherited;
    }

    public Object getModel() {
        return this.objectCombo.getSelectedItem();
    }

    public String getRModel() {
        Object object = this.objectCombo.getSelectedItem();
        if (object != null) {
            return "\"" + object.toString() + "\"";
        }
        return "NULL";
    }

    public String getTitle() {
        return this.title;
    }

    public void reset() {
        this.setModel(this.initialModel);
    }

    public void resetToLast() {
        this.setModel(this.lastModel);
    }

    public void setDefaultModel(Object object) {
        this.initialModel = (String)object;
        if (this.lastModel == null) {
            this.lastModel = (String)object;
        }
    }

    public void setLastModel(Object object) {
        this.lastModel = (String)object;
    }

    public void setModel(Object object) {
        if (this.objectCombo.getModel().getSize() == 0) {
            return;
        }
        if (object == null) {
            this.objectCombo.setSelectedIndex(0);
        } else {
            this.objectCombo.setSelectedItem(object);
        }
    }

    public void setTitle(String string, boolean bl) {
        this.title = string;
        this.titleLabel.setText(this.title);
        this.show = bl;
        this.resetLayout();
    }

    public void setTitle(String string) {
        this.setTitle(string, false);
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
        this.refreshObjects();
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }
}

