/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.EventListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.rosuda.deducer.widgets.DeducerWidget;

public class ButtonGroupWidget
extends JPanel
implements DeducerWidget {
    private ButtonGroup group;
    private String title;
    private Vector radioBoxes;
    private Vector names = new Vector();
    private String initialModel;
    private String lastModel;

    public ButtonGroupWidget(String string, String[] stringArray) {
        this.radioBoxes = new Vector();
        this.title = string;
        for (int i = 0; i < stringArray.length; ++i) {
            this.names.add(stringArray[i]);
            JRadioButton jRadioButton = new JRadioButton();
            jRadioButton.setText(stringArray[i]);
            this.radioBoxes.add(jRadioButton);
        }
        this.initGUI();
    }

    public ButtonGroupWidget(String[] stringArray) {
        this(null, stringArray);
    }

    private void initGUI() {
        try {
            this.group = new ButtonGroup();
            this.setPreferredSize(new Dimension(146, 149));
            BoxLayout boxLayout = new BoxLayout(this, 1);
            this.setLayout(boxLayout);
            if (this.title != null) {
                this.setBorder(BorderFactory.createTitledBorder(this.title));
            }
            for (int i = 0; i < this.radioBoxes.size(); ++i) {
                JRadioButton jRadioButton = (JRadioButton)this.radioBoxes.get(i);
                this.group.add(jRadioButton);
                if (i == 0) {
                    this.add(Box.createVerticalGlue());
                }
                this.add(jRadioButton);
                this.add(Box.createVerticalGlue());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Vector getButtons() {
        return this.radioBoxes;
    }

    public String[] getNames() {
        return (String[])this.names.toArray();
    }

    public String getSelectedItemText() {
        return (String)this.getModel();
    }

    public JRadioButton getSelectedButton() {
        for (int i = 0; i < this.radioBoxes.size(); ++i) {
            JRadioButton jRadioButton = (JRadioButton)this.radioBoxes.get(i);
            if (!jRadioButton.isSelected()) continue;
            return jRadioButton;
        }
        return null;
    }

    public void setSelected(String string) {
        this.setModel(string);
    }

    public void setSelected(JRadioButton jRadioButton) {
        this.setModel(jRadioButton.getText());
    }

    public void addButton(JRadioButton jRadioButton) {
        this.group.add(jRadioButton);
        this.add(jRadioButton);
        this.radioBoxes.add(jRadioButton);
        this.names.add(jRadioButton.getText());
    }

    public void addButton(String string) {
        JRadioButton jRadioButton = new JRadioButton(string);
        this.group.add(jRadioButton);
        this.add(jRadioButton);
        this.radioBoxes.add(jRadioButton);
        this.names.add(jRadioButton.getText());
    }

    public void removeButton(int n) {
        JRadioButton jRadioButton = (JRadioButton)this.radioBoxes.remove(n);
        this.names.remove(n);
        this.remove(jRadioButton);
    }

    public void addListener(EventListener eventListener) {
        for (int i = 0; i < this.radioBoxes.size(); ++i) {
            JRadioButton jRadioButton = (JRadioButton)this.radioBoxes.get(i);
            if (eventListener instanceof ActionListener) {
                jRadioButton.addActionListener((ActionListener)eventListener);
            }
            if (!(eventListener instanceof MouseListener)) continue;
            jRadioButton.addMouseListener((MouseListener)eventListener);
        }
    }

    public Object getModel() {
        for (int i = 0; i < this.radioBoxes.size(); ++i) {
            JRadioButton jRadioButton = (JRadioButton)this.radioBoxes.get(i);
            if (!jRadioButton.isSelected()) continue;
            return jRadioButton.getText();
        }
        return null;
    }

    public String getRModel() {
        Object object = this.getModel();
        if (object == null) {
            return "c()";
        }
        return "\"" + (String)object + "\"";
    }

    public String getTitle() {
        return this.title;
    }

    public void reset() {
        this.setModel(this.initialModel);
    }

    public void resetToLast() {
        this.setModel(this.lastModel);
    }

    public void setLastModel(Object object) {
        if (object == null) {
            object = this.names.get(0);
        }
        this.lastModel = (String)object;
    }

    public void setModel(Object object) {
        if (object == null) {
            object = this.names.get(0);
        }
        String string = (String)object;
        for (int i = 0; i < this.radioBoxes.size(); ++i) {
            JRadioButton jRadioButton = (JRadioButton)this.radioBoxes.get(i);
            if (!jRadioButton.getText().equals(string)) continue;
            jRadioButton.setSelected(true);
        }
    }

    public void setTitle(String string, boolean bl) {
        this.title = string;
        if (string == null) {
            this.setBorder(BorderFactory.createEmptyBorder());
        } else if (bl) {
            this.setBorder(BorderFactory.createTitledBorder(this.title));
        }
    }

    public void setTitle(String string) {
        this.setTitle(string, false);
    }

    public void setDefaultModel(Object object) {
        if (object == null) {
            object = this.names.get(0);
        }
        this.initialModel = (String)object;
        if (this.lastModel == null) {
            this.lastModel = (String)object;
        }
    }
}

