/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.plots;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.plots.ElementModel;
import org.rosuda.deducer.plots.ElementView;
import org.rosuda.deducer.plots.PlotBuilder;
import org.rosuda.deducer.plots.PlotBuilderModel;
import org.rosuda.deducer.plots.PlottingElement;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;

public class PlottingElementMenuDialog
extends JDialog
implements ActionListener {
    private JPanel panel;
    private OkayCancelPanel okayCancel;
    private HelpButton help;
    private ElementView view;
    private ElementModel initialModel;
    private PlottingElement element;

    public PlottingElementMenuDialog(JFrame jFrame, PlottingElement plottingElement) {
        super(jFrame);
        try {
            this.initGUI();
            this.initialModel = (ElementModel)plottingElement.getModel().clone();
            this.setElement(plottingElement);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void initGUI() {
        try {
            AnchorLayout anchorLayout = new AnchorLayout();
            this.getContentPane().setLayout((LayoutManager)anchorLayout);
            this.help = new HelpButton("");
            this.getContentPane().add((Component)this.help, new AnchorConstraint(923, 92, 12, 12, 0, 0, 2, 2));
            this.help.setPreferredSize(new Dimension(36, 36));
            this.okayCancel = new OkayCancelPanel(true, true, this);
            this.getContentPane().add((Component)this.okayCancel, new AnchorConstraint(923, 21, 0, 521, 0, 2, 2, 0));
            this.okayCancel.setPreferredSize(new Dimension(250, 38));
            this.okayCancel.getResetButton().setText("Builder");
            this.okayCancel.getResetButton().setActionCommand("Builder");
            this.panel = new JPanel();
            BorderLayout borderLayout = new BorderLayout();
            this.panel.setLayout(borderLayout);
            this.getContentPane().add((Component)this.panel, new AnchorConstraint(1, 994, 44, 1, 1, 1, 2, 1));
            this.panel.setPreferredSize(new Dimension(447, 449));
            this.setSize(450, 515);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setElement(PlottingElement plottingElement) {
        this.setView((ElementView)plottingElement.getPanel());
        this.initialModel = (ElementModel)plottingElement.getModel().clone();
        this.help.setUrl(plottingElement.getUrl());
        this.help.setToolTipText("Open online help from: " + plottingElement.getUrl());
        this.element = plottingElement;
        this.setTitle(this.element.getName());
    }

    public void setView(ElementView elementView) {
        this.view = elementView;
        this.panel.removeAll();
        this.panel.add(this.view);
    }

    public void setToInitialModel() {
        this.element.setModel(this.initialModel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == "Run") {
            this.view.updateModel();
            String string2 = this.view.getModel().checkValid();
            if (string2 != null) {
                JOptionPane.showMessageDialog(this, string2);
            } else {
                PlotBuilderModel plotBuilderModel = new PlotBuilderModel();
                plotBuilderModel.getListModel().addElement(this.element);
                Deducer.execute(plotBuilderModel.getCall());
                this.dispose();
            }
        } else if (string == "Builder") {
            this.view.updateModel();
            String string3 = this.view.getModel().checkValid();
            if (string3 != null) {
                JOptionPane.showMessageDialog(this, string3);
            } else {
                PlotBuilderModel plotBuilderModel = new PlotBuilderModel();
                plotBuilderModel.getListModel().addElement(this.element.clone());
                PlotBuilder plotBuilder = new PlotBuilder(plotBuilderModel);
                plotBuilder.setLocationRelativeTo(this);
                this.dispose();
                plotBuilder.setVisible(true);
            }
        } else if (string == "Cancel") {
            this.setToInitialModel();
            this.dispose();
        }
    }
}

