/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.data;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.rosuda.JGR.DataLoader;
import org.rosuda.JGR.util.ErrorMsg;
import org.rosuda.REngine.REXP;
import org.rosuda.REngine.REXPMismatchException;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.data.DataObject;
import org.rosuda.deducer.data.DataRefresher;
import org.rosuda.deducer.data.DataViewFactory;
import org.rosuda.deducer.data.DataViewer;
import org.rosuda.deducer.data.DataViewerTab;
import org.rosuda.deducer.data.DataViewerTabFactory;
import org.rosuda.deducer.data.VariableViewFactory;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.IconButton;

public class DataViewerController {
    private static ArrayList dataWindows;
    private static Map tabFactories;
    private static boolean started;
    private static JPanel panel;
    private static boolean saveButton;
    private static boolean openButton;
    private static boolean clearButton;
    private static Map datasets;
    private static HashSet dataTypes;
    private static Map typeShortNames;

    public static void init() {
        if (!started) {
            dataWindows = new ArrayList();
            datasets = new LinkedHashMap();
            dataTypes = new HashSet();
            tabFactories = new LinkedHashMap();
            typeShortNames = new LinkedHashMap();
            DataViewerController.addDataType("data.frame", "df");
            DataViewerController.addTabFactory("data.frame", "Data View", new DataViewFactory());
            DataViewerController.addTabFactory("data.frame", "Variable View", new VariableViewFactory());
            saveButton = true;
            openButton = true;
            clearButton = true;
            panel = new JPanel();
            GridBagLayout gridBagLayout = new GridBagLayout();
            gridBagLayout.rowWeights = new double[]{0.1, 0.1, 0.25, 0.1, 0.1};
            panel.setLayout(gridBagLayout);
            ActionListener actionListener = new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String string = actionEvent.getActionCommand();
                    if (string == "Open Data") {
                        new DataLoader();
                    } else if (string == "New Data") {
                        String string2 = JOptionPane.showInputDialog("Data Name: ");
                        if (string2 != null) {
                            Deducer.threadedEval(string2.trim() + "<-data.frame(Var1=NA)");
                        }
                    } else if (string == "tutorial") {
                        HelpButton.showInBrowser("http://www.youtube.com/user/MrIanfellows#p/u/5/iZ857h2j6wA");
                    } else if (string == "wiki") {
                        HelpButton.showInBrowser("http://www.deducer.org/manual.html");
                    }
                }
            };
            IconButton iconButton = new IconButton("/icons/newdata_128.png", "New Data Frame", actionListener, "New Data");
            iconButton.setContentAreaFilled(false);
            iconButton.setPreferredSize(new Dimension(128, 128));
            panel.add((Component)iconButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            IconButton iconButton2 = new IconButton("/icons/opendata_128.png", "Open Data Frame", actionListener, "Open Data");
            iconButton2.setContentAreaFilled(false);
            iconButton2.setPreferredSize(new Dimension(128, 128));
            panel.add((Component)iconButton2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            IconButton iconButton3 = new IconButton("/icons/video_128.png", "Online Tutorial Video", actionListener, "tutorial");
            iconButton3.setContentAreaFilled(false);
            iconButton3.setPreferredSize(new Dimension(128, 128));
            panel.add((Component)iconButton3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            IconButton iconButton4 = new IconButton("/icons/info_128.png", "Online Manual", actionListener, "wiki");
            iconButton4.setContentAreaFilled(false);
            iconButton4.setPreferredSize(new Dimension(128, 128));
            panel.add((Component)iconButton4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
            started = true;
            new Thread(new DataRefresher()).start();
        }
    }

    public static void addViewerWindow(DataViewer dataViewer) {
        dataWindows.add(0, dataViewer);
    }

    public static ArrayList getViewerWindows() {
        return dataWindows;
    }

    public static void removeViewerWindow(DataViewer dataViewer) {
        dataWindows.remove(dataViewer);
    }

    public static void addTabFactory(String string, String string2, DataViewerTabFactory dataViewerTabFactory) {
        tabFactories.put(string2, dataViewerTabFactory);
        if (!tabFactories.containsKey(string)) {
            tabFactories.put(string, new LinkedHashMap());
        }
        Map map = (Map)tabFactories.get(string);
        map.put(string2, dataViewerTabFactory);
        for (int i = 0; i < dataWindows.size(); ++i) {
            DataViewer dataViewer = (DataViewer)dataWindows.get(i);
            DataObject dataObject = dataViewer.getData();
            dataViewer.reloadTabs(dataObject);
        }
    }

    public static void removeTabFactory(String string, String string2) {
        Map map = (Map)tabFactories.get(string);
        map.remove(string2);
        for (int i = 0; i < dataWindows.size(); ++i) {
            DataViewer dataViewer = (DataViewer)dataWindows.get(i);
            DataObject dataObject = dataViewer.getData();
            dataViewer.reloadTabs(dataObject);
        }
    }

    public static String[] getTabNames(String string) {
        Map map = (Map)tabFactories.get(string);
        Object[] objectArray = map.keySet().toArray();
        String[] stringArray = new String[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            stringArray[i] = (String)objectArray[i];
        }
        return stringArray;
    }

    public static DataViewerTab generateTab(String string, String string2, String string3) {
        Map map = (Map)tabFactories.get(string);
        DataViewerTabFactory dataViewerTabFactory = (DataViewerTabFactory)map.get(string2);
        if (dataViewerTabFactory == null) {
            new ErrorMsg("Unknown DataViewerTabFactory: " + string2);
            return null;
        }
        return dataViewerTabFactory.makeViewerTab(string3);
    }

    public static JPanel getDefaultPanel() {
        return panel;
    }

    public static void setDefaultPanel(JPanel jPanel) {
        panel = jPanel;
    }

    public static boolean showSaveDataButton() {
        return saveButton;
    }

    public static boolean showOpenDataButton() {
        return openButton;
    }

    public static boolean showClearDataButton() {
        return clearButton;
    }

    public static void setSaveDataVisible(boolean bl) {
        saveButton = bl;
    }

    public static void setOpenDataVisible(boolean bl) {
        openButton = bl;
    }

    public static void setClearDataVisible(boolean bl) {
        clearButton = bl;
    }

    public static void addDataType(String string, String string2) {
        dataTypes.add(string);
        typeShortNames.put(string, string2);
    }

    public static boolean removeDataType(String string, String string2) {
        typeShortNames.remove(string);
        return dataTypes.remove(string);
    }

    public static synchronized void refreshData() {
        Iterator iterator = dataTypes.iterator();
        while (iterator.hasNext()) {
            REXP rEXP;
            String string = iterator.next().toString();
            String string2 = (String)typeShortNames.get(string);
            if (string2 == null) {
                string2 = "";
            }
            if ((rEXP = Deducer.idleEval("get.objects('" + string + "',includeInherited=FALSE)")) == null || !rEXP.isString()) continue;
            try {
                String[] stringArray = rEXP.asStrings();
                datasets.remove(string);
                LinkedList<DataObject> linkedList = new LinkedList<DataObject>();
                for (int i = 0; i < stringArray.length; ++i) {
                    linkedList.add(new DataObject(stringArray[i], string, string2));
                }
                datasets.put(string, linkedList);
            }
            catch (REXPMismatchException rEXPMismatchException) {
                rEXPMismatchException.printStackTrace();
            }
        }
    }

    public static LinkedList getDataSets() {
        Object[] objectArray = datasets.keySet().toArray();
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < objectArray.length; ++i) {
            linkedList.addAll((List)datasets.get((String)objectArray[i]));
        }
        return linkedList;
    }

    static {
        started = false;
    }
}

