% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagnosis_helper_functions.R
\name{reshape_diagnosis}
\alias{reshape_diagnosis}
\title{Clean up a diagnosis object for printing}
\usage{
reshape_diagnosis(diagnosis, digits = 2, select = NULL, exclude = NULL)
}
\arguments{
\item{diagnosis}{A diagnosis object generated by \code{diagnose_design}.}

\item{digits}{Number of digits.}

\item{select}{List of columns to include in output. Defaults to all.}

\item{exclude}{Set of columns to exclude from output. Defaults to none.}
}
\value{
A formatted text table with bootstrapped standard errors in parentheses.
}
\description{
Take a diagnosis object and returns a pretty output table. If diagnosands are bootstrapped, se's are put in parentheses on a second line and rounded to \code{digits}.
}
\examples{

# Two-arm randomized experiment
design <-
  declare_model(
    N = 500,
    gender = rbinom(N, 1, 0.5),
    X = rep(c(0, 1), each = N / 2),
    U = rnorm(N, sd = 0.25),
    potential_outcomes(Y ~ 0.2 * Z + X + U)
  ) +
  declare_inquiry(ATE = mean(Y_Z_1 - Y_Z_0)) +
  declare_sampling(S = complete_rs(N = N, n = 200)) +
  declare_assignment(Z = complete_ra(N = N, m = 100)) +
  declare_measurement(Y = reveal_outcomes(Y ~ Z)) +
  declare_estimator(Y ~ Z, inquiry = "ATE")

\dontrun{
# Diagnose design using default diagnosands
diagnosis <- diagnose_design(design)
diagnosis

# Return diagnosis output table
reshape_diagnosis(diagnosis)

# Return table with subset of diagnosands
reshape_diagnosis(diagnosis, select = c("Bias", "Power"))

# With user-defined diagnosands
my_diagnosands <-
  declare_diagnosands(median_bias = median(estimate - estimand),
                      absolute_error = mean(abs(estimate - estimand)))

diagnosis <- diagnose_design(design, diagnosands = my_diagnosands)
diagnosis

reshape_diagnosis(diagnosis)

reshape_diagnosis(diagnosis, select = "Absolute Error")

# Alternative: Use tidy to produce data.frame with results of 
# diagnosis including bootstrapped standard errors and 
# confidence intervals for each diagnosand
diagnosis_df <- tidy(diagnosis)
diagnosis_df

}
}
