% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CPCdata.frame.R
\name{CPCdata.frame}
\alias{CPCdata.frame}
\title{Data Manipulation for CPC Calculation}
\usage{
CPCdata.frame(data, cols, clusters)
}
\arguments{
\item{data}{a numeric \code{n x k} matrix or data frame.}

\item{cols}{columns in \code{data} to be used for calculating \code{\link{CPC}()}.}

\item{clusters}{column in \code{data} giving cluster membership.}
}
\value{
Returns a data frame with dimensions identical to those of \code{data}.
}
\description{
Converts numeric matrix to data frame with necessary format for
\code{"manual"} \code{\link{CPC}()} calculation.
}
\examples{
data <- matrix(c(rnorm(50, 0, 1), rnorm(50, 5, 1)), ncol = 2, byrow = TRUE)
clusters <- matrix(c(rep(1, 25), rep(2, 25)), ncol = 1)
data <- cbind(data, clusters)
CPCdata.frame(data, 1:2, 3)

}
