% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step_bw_firth.R
\name{step_bw_firth}
\alias{step_bw_firth}
\title{Stepwise backward for logistic Firth regression with automated dummy variables conversion}
\usage{
step_bw_firth(
  reg_model,
  s_lower = "~1",
  s_upper = "all",
  trace = TRUE,
  steps = NULL,
  p_threshold = 0.05,
  data = NULL
)
}
\arguments{
\item{reg_model}{Regression model. Must be a glm or lm model}

\item{s_lower}{Lower step. Names of the variables to be included at the lower step. Default is "~1" (Intercept)}

\item{s_upper}{Upper step. Names of the variables to be included at the upper step. Default is "all" (Includes all variables in a dataframe)}

\item{trace}{Trace the steps in R console. Display the output of each iteration. Default is TRUE. Regression models of the \code{logistf} class are designed to print on the console when the \code{summary.logistf} method from \code{logistf} package is used. Since this function repeatedly uses this function, some part of the process will be printed on the console even when "trace" is set to \code{FALSE}.}

\item{steps}{Maximum number of steps in the process. If NULL, steps will be the length of the regression model introduced.}

\item{p_threshold}{Treshold of p value. Default is 0.05}

\item{data}{Dataframe to execute the stepwise process. If NULL, data will be assigned from the regression model data.}
}
\value{
An oject class step_bw containing the final model an each step performed in backward regression. The final model can be accessed using $ operator
}
\description{
Extension code to perform stepwise backward to a logistf model with categorical variables. Automatically transforms predictors of the model which are factors to dummy variables.
}
\examples{
if(requireNamespace("logistf")){
library(logistf)

data<-mtcars
data$am<-as.factor(data$am)

regression_model<-logistf::logistf(am~mpg+cyl+disp, data=data)
stepwise<-step_bw_firth(regression_model, trace=FALSE)

final_stepwise_model<-stepwise$final_model

# Show steps
stepwise$steps

summary(final_stepwise_model)
}


}
\references{
Heinze G, Ploner M, Jiricka L, Steiner G. logistf: Firth’s Bias-Reduced Logistic Regression. 2023. Available on: \url{https://CRAN.R-project.org/package=logistf}

Efroymson MA. Multiple regression analysis. In: Ralston A, Wilf HS, editors. Mathematical methods for digital computers. New York: Wiley; 1960.

Ullmann T, Heinze G, Hafermann L, Schilhart-Wallisch C, Dunkler D, et al. (2024) Evaluating variable selection methods for multivariable regression models: A simulation study protocol. PLOS ONE 19(8): e0308543
}
