% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SDF_GMM.R
\name{SDF_gmm}
\alias{SDF_gmm}
\title{GMM Estimates of Factors' Risk Prices under the Linear SDF Framework}
\usage{
SDF_gmm(R, f, W)
}
\arguments{
\item{R}{A matrix of test assets with dimension \eqn{t \times N}, where \eqn{t} is the number of periods
and \eqn{N} is the number of test assets;}

\item{f}{A matrix of factors with dimension \eqn{t \times k}, where \eqn{k} is the number of factors
and \eqn{t} is the number of periods;}

\item{W}{Weighting matrix in GMM estimation (see \bold{Details}).}
}
\value{
The return of \code{SDF_gmm} is a list of the following elements:
\itemize{
\item \code{lambda_gmm}: Risk price estimates;
\item \code{mu_f}: Sample means of factors;
\item \code{Avar_hat}: Asymptotic covariance matrix of GMM estimates (see \bold{Details});
\item \code{R2_adj}: Adjusted cross-sectional \eqn{R^2};
\item \code{S_hat}: Spectral matrix.
}
}
\description{
This function provides the GMM estimates of factors' risk prices under the linear SDF framework (including the common intercept).
}
\details{
We follow the notations in Section I of \insertCite{bryzgalova2023bayesian;textual}{BayesianFactorZoo}.
Suppose that there are \eqn{K} factors, \eqn{f_t = (f_{1t},...,f_{Kt})^\top, t=1,...,T}.
The returns of \eqn{N} test assets are denoted by \eqn{R_t = (R_{1t},...,R_{Nt})^\top}.

Consider linear SDFs (\eqn{M}), that is, models of the form \eqn{M_t = 1- (f_t -E[f_t])^\top \lambda_f}.

The model is estimated via GMM with moment conditions

\deqn{E[g_t (\lambda_c, \lambda_f, \mu_f)] =E\left(\begin{array}{c} R_t - \lambda_c 1_N - R_t (f_t - \mu_f)^\top \lambda_f \\ f_t - \mu_f \end{array} \right) =\left(\begin{array}{c}  0_N \\ 0_K \end{array} \right)}
and the corresponding sample analog function \eqn{ g_T (\lambda_c, \lambda_f, \mu_f) = \frac{1}{T} \Sigma_{t=1}^T  g_t (\lambda_c, \lambda_f, \mu_f)}. Different weighting matrices deliver different point estimates. Two popular choices are
\deqn{	W_{ols}=\left(\begin{array}{cc}I_N & 0_{N \times K}  \\ 0_{K \times N} & \kappa I_K\end{array}\right), \ \ W_{gls}=\left(\begin{array}{cc} \Sigma_R^{-1} & 0_{N \times K}  \\ 0_{K \times N} & \kappa I_K\end{array}\right), }
where \eqn{\Sigma_R} is the covariance matrix of returns and \eqn{\kappa >0} is a large constant so that \eqn{\hat{\mu}_f = \frac{1}{T} \Sigma_{t=1}^{T} f_t }.

The asymptotic covariance matrix of risk premia estimates, \code{Avar_hat}, is based on the assumption that
\eqn{g_t (\lambda_c, \lambda_f, \mu_f)} is independent over time.
}
\references{
\insertRef{bryzgalova2023bayesian}{BayesianFactorZoo}
}
