% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitted_hp.R
\name{fitted.HP}
\alias{fitted.HP}
\title{HP Model: Fitted death probabilities (qx)}
\usage{
\method{fitted}{HP}(object, age = NULL, ...)
}
\arguments{
\item{object}{Object of the class \code{HP} or \code{ClosedHP} adjusted by the hp() or hp_close() functions.}

\item{age}{Vector with the ages to calculate the death probabilities (Optional). By default, all ages are considered.}

\item{...}{Other arguments.}
}
\value{
A data.frame object with the selected ages and the corresponding death probabilities.
}
\description{
This function computes the point estimations of the death probabilities (qx) of the \code{HP} or the \code{ClosedHP} class object fitted by the hp() or hp_close() functions.
}
\examples{
## Importing mortality data from the USA available on the Human Mortality Database (HMD):
data(USA)

## Selecting the exposure and the death count of the year 2000, ranging from 0 to 90 years old:
USA2000 = USA[USA$Year == 2000,]
x = 0:90
Ex = USA2000$Ex.Total[x+1]
Dx = USA2000$Dx.Total[x+1]

## Fitting a simple model:
fit = hp(x = x, Ex = Ex, Dx = Dx, M = 5000, bn = 0, thin = 10)

## Estimating the death probabilities (qx)
fitted(fit)
fitted(fit, age = 0:110)

}
\seealso{
\code{\link[=fitted.BLC]{fitted.BLC()}} and \code{\link[=fitted.DLM]{fitted.DLM()}} for \code{BLC} or \code{DLM} methods.
}
