% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sb.R
\name{sb}
\alias{sb}
\alias{sblb}
\title{Spatial balance}
\usage{
sb(prob, x, sample, type = "kdtree2", bucketSize = 10)

sblb(prob, x, sample, type = "kdtree2", bucketSize = 10)
}
\arguments{
\item{prob}{A vector of length N with inclusion probabilities, or an integer > 1. If an integer n, then the sample will be drawn with equal probabilities n / N.}

\item{x}{An N by p matrix of (standardized) auxiliary variables. Squared euclidean distance is used in the \code{x} space.}

\item{sample}{A vector of sample indices.}

\item{type}{The method used in finding nearest neighbours.
Must be one of \code{"kdtree0"}, \code{"kdtree1"}, \code{"kdtree2"}, and
\code{"notree"}.}

\item{bucketSize}{The maximum size of the terminal nodes in the k-d-trees.}
}
\value{
The balance measure of the provided sample.
}
\description{
Calculates the spatial balance of a sample.
}
\details{
About voronoi and sumofsquares
}
\section{Functions}{
\itemize{
\item \code{sblb()}: Spatial balance using local balance

}}
\section{k-d-trees}{

The \code{type}s "kdtree" creates k-d-trees with terminal node bucket sizes
according to \code{bucketSize}.

\itemize{
\item{"kdtree0"} creates a k-d-tree using a median split on alternating variables.
\item{"kdtree1"} creates a k-d-tree using a median split on the largest range.
\item{"kdtree2"} creates a k-d-tree using a sliding-midpoint split.
\item{"notree"} does a naive search for the nearest neighbour.
}
}

\examples{
\dontrun{
set.seed(12345);
N = 500;
n = 70;
prob = rep(n / N, N);
x = matrix(runif(N * 2), ncol = 2);
s = lpm2(prob, x);
b = sb(prob, x, s);
}
}
\references{
Friedman, J. H., Bentley, J. L., & Finkel, R. A. (1977).
An algorithm for finding best matches in logarithmic expected time.
ACM Transactions on Mathematical Software (TOMS), 3(3), 209-226.

Maneewongvatana, S., & Mount, D. M. (1999, December).
It’s okay to be skinny, if your friends are fat.
In Center for geometric computing 4th annual workshop on computational geometry (Vol. 2, pp. 1-8).

Stevens Jr, D. L., & Olsen, A. R. (2004).
Spatially balanced sampling of natural resources.
Journal of the American statistical Association, 99(465), 262-278.

Grafström, A., Lundström, N.L.P. & Schelin, L. (2012).
Spatially balanced sampling through the Pivotal method.
Biometrics 68(2), 514-520.

Prentius, W, & Grafström A. (2023).
Manuscript.
}
\seealso{
Other measure: 
\code{\link{vsb}()}

Other measure: 
\code{\link{vsb}()}
}
\concept{measure}
